<div>
    <title>Mecubro | Siniestros</title>
    <?php if(session()->has('message-danger')): ?>
        <div class="alert alert-danger">
            <?php echo e(session('message-danger')); ?>

        </div>
    <?php endif; ?>
    <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('components.page-filters', ['meta' => $meta, 'filters' => 'id, Doc, usuario o Desc'])->html();
} elseif ($_instance->childHasBeenRendered('l190507471-0')) {
    $componentId = $_instance->getRenderedChildComponentId('l190507471-0');
    $componentTag = $_instance->getRenderedChildComponentTagName('l190507471-0');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('l190507471-0');
} else {
    $response = \Livewire\Livewire::mount('components.page-filters', ['meta' => $meta, 'filters' => 'id, Doc, usuario o Desc']);
    $html = $response->html();
    $_instance->logRenderedChild('l190507471-0', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
    <div wire:loading.block class="alert alert-info" role="alert">
        Actualizando Estado de la operacion... <img src="/assets/img/loading.gif" width="35px">
    </div>
    <div class="message-wrapper border-0 bg-white shadow rounded mb-1" style="clear:both">
        <div class="card-body d-flex align-items-center flex-wrap flex-lg-nowrap py-0">
            <div class="col-1 align-items-center px-0 d-none d-lg-flex" style="width: 65px">ID</div>
            <div class="col-4 col-lg-1 ps-0 ps-lg-3 pe-lg-3" style="width: 130px">Fecha</div>
            <div class="col-4 col-lg-1 ps-0 ps-lg-3 pe-lg-3">Estado</div>
            <div class="col-1 col-lg-1 ps-0 ps-lg-3 pe-lg-3">Riesgo</div>
            <div class="col-4 col-lg-2 ps-0 ps-lg-3 pe-lg-3">Asegurado</div>

            <div class="col-4 col-lg-1 ps-0 ps-lg-3 pe-lg-3">Seguro</div>
            <div class="col-4 col-lg-1 ps-0 ps-lg-3 pe-lg-3">Declarado</div>

        </div>
    </div>
    <?php if(!$siniestros || $siniestros == null): ?>
        <div class="alert alert-success" role="alert">
            <i class="fa fa-superpowers" aria-hidden="true"></i>Sin resultados para la busqueda generada.
        </div>
    <?php else: ?>




    <?php $__currentLoopData = $siniestros; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $siniestro): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <div class="message-wrapper border-0 bg-white shadow rounded mb-1" style="clear:both; font-size:13px">
        <div class="card hover-state border-bottom rounded-0 rounded-top my-2">
            <div class="card-body d-flex align-items-center flex-wrap flex-lg-nowrap py-0">
                <div class="col-6 col-lg-1 align-items-center px-0 d-lg-flex" style="width: 65px">
                    AP<?php echo e($siniestro['id']); ?> <span class="flecha">></span>
                </div>
                <div class="col-6 col-lg-2 ps-0 ps-lg-3 pe-lg-3" style="width: 130px">
                    <?php echo e($this->getFecha($siniestro['date'])); ?> <br>
                    <?php echo e($siniestro['hour']); ?>

                </div>
                <div class="col-9 col-lg-1 ps-0 ps-lg-2 pe-lg-2">
                    <button type="button"
                        wire:click="changeStatus(<?php echo e($siniestro['id']); ?>,'<?php echo e($siniestro['status_nice']); ?>')"
                        class="btn btn-block mecubro-btn1" data-bs-toggle="modal"
                        data-bs-target="#modalNotification"><?php echo e($siniestro['status_nice']); ?></button>

                </div>
                <div class="col-6 col-lg-2 ps-0 ps-lg-3 pe-lg-3" style="width: 130px">
                    <?php echo e($siniestro['risk_type']['name']); ?>

                </div>

                <div class="col-6 col-lg-2 ps-0 ps-lg-3 pe-lg-3">
                    <?php echo e($siniestro['insurance_risk']['insured_entity']['name_nice']); ?> <br> <?php echo e($siniestro['insurance_risk']['insured_entity']['document_nice']); ?>

                </div>
                <div class="col-6 col-lg-2 ps-0 ps-lg-3 pe-lg-3" style="width: 130px">
                    <?php echo e($siniestro['insurance_risk']['id']); ?>

                    <img src="<?php echo e($siniestro['coverage']['policy']['company']['logo_filename']); ?>"  onerror="this.src = '/assets/img/sf.jpg';"
                    class="avatar-sm rounded-circle me-3"
                    alt="<?php echo e($siniestro['coverage']['policy']['company']['name']); ?>">
                </div>


                <div class="col-6 col-lg-2 ps-0 ps-lg-3 pe-lg-3" style="width: 130px">
                    <?php echo e($this->getFecha($siniestro['created_at'],1)); ?>

                </div>

                <div class="col-12 col-lg-3 ps-0 ps-lg-3 pe-lg-3">
                             <a type="button" class="btn btn-block mecubro-btn1"
                        href="/siniestros-mensajes/<?php echo e($siniestro['id']); ?>">Historial / msj</a>
                </div>


                <div class="col-3 col-lg-1 d-flex align-items-center justify-content-end px-0 order-lg-2">
                    <div class="dropdown ms-3">
                        <button type="button" class="btn btn-sm fs-6 px-1 py-0 dropdown-toggle"
                            id="dropdownMenuLink" data-bs-toggle="dropdown" aria-expanded="false">
                            <svg class="icon icon-xs" fill="currentColor" viewBox="0 0 20 20"
                                xmlns="http://www.w3.org/2000/svg">
                                <path
                                    d="M6 10a2 2 0 11-4 0 2 2 0 014 0zM12 10a2 2 0 11-4 0 2 2 0 014 0zM16 12a2 2 0 100-4 2 2 0 000 4z">
                                </path>
                            </svg>
                        </button>
                        <div class="dropdown-menu dashboard-dropdown dropdown-menu-start mt-2 py-1">
                            <a class="dropdown-item d-flex align-items-center"
                                href="/siniestros-mensajes/<?php echo e($siniestro['id']); ?>">
                                <svg class="dropdown-icon text-gray-400 me-2" fill="currentColor"
                                    viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M4 3a2 2 0 100 4h12a2 2 0 100-4H4z"></path>
                                    <path fill-rule="evenodd"
                                        d="M3 8h14v7a2 2 0 01-2 2H5a2 2 0 01-2-2V8zm5 3a1 1 0 011-1h2a1 1 0 110 2H9a1 1 0 01-1-1z"
                                        clip-rule="evenodd"></path>
                                </svg> Chat / Mensajes
                            </a>
                            <div role="separator" class="dropdown-divider my-1"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>



    <?php endif; ?>
    <?php if($modal_open == true): ?>
        <!-- Modal Content -->
        <div class="modal fade show" id="modalNotification" tabindex="-1" role="dialog"
            aria-labelledby="modalTitleNotify" aria-modal="true" style="display: block;">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <p class="modal-title" id="modalTitleNotify">Modificar estado de un siniestro.</p>
                        <button type="button" wire:click="cerrarModal()" class="btn-close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="py-3 text-center">
                            Estado actual: <strong><?php echo e($siniestro_activo_estado); ?></strong>
                            <h2 class="h4 modal-title my-3">¿Que estado desea asignar?</h2>
                            <ul style="list-style-type:none">
                                <?php $__currentLoopData = $siniestros_estados; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $estado): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($estado['id'] != $siniestro_activo_id): ?>
                                        <li class="page-item">
                                            <button class="page-link btn-status" href="#"
                                                wire:click="changeStatusSave(<?php echo e($estado['id']); ?>)"
                                                wire:loading.attr="disabled"><?php echo e($estado['name']); ?></button>
                                        </li>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                        <div wire:loading.block class="alert alert-success" role="alert">
                            Actualizando Estado...
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal-backdrop fade show"></div>
        <!-- Fin modal -->
    <?php endif; ?>
</div>
<?php /**PATH C:\home\mecubro-admin.local\resources\views/livewire/siniestros/siniestros.blade.php ENDPATH**/ ?>