<div>
    <title>Mecubro | Ficha de un Seguros</title>
    <?php if(session()->has('message-danger')): ?>
    <div class="alert alert-danger">
        <?php echo e(session('message-danger')); ?>

    </div>
<?php endif; ?>
    <div class="row">
        <div class="col-12 col-xl-8">
            <div class="card card-body border-0 shadow mb-4">
                <h2 class="h5 mb-4">Datos del seguro</h2>



                <form>
                    <div class="row">
                        <div class="col-md-4 mb-3">
                            <div>
                                <label for="first_name">Tipo de Riesgo</label>
                                <div class="seguro-data"><?php echo e($seguro['id']); ?> -
                                    <?php echo e($seguro['insurance']['risk_type']['name']); ?></div>
                            </div>
                        </div>
                        <div class="col-md-4 mb-3">
                            <div>
                                <label for="last_name">SubTipo</label>
                                <div class="seguro-data"><?php echo e($seguro['risk']['risk_sub_type']['id']); ?> -
                                    <?php echo e($seguro['risk']['risk_sub_type']['name']); ?></div>
                            </div>
                        </div>
                        <div class="col-md-4 mb-3"><label for="birthday">Estado</label>
                            <div class="seguro-data"><?php echo e($seguro['status']); ?></div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-4 mb-3"><label for="birthday">Valido desde</label>
                            <div class="seguro-data"><?php echo e($this->getFecha($seguro['validity_start'],1)); ?></div>
                        </div>
                        <div class="col-md-4 mb-3"><label for="gender">Valido hasta</label>
                            <div class="seguro-data"><?php echo e($this->getFecha($seguro['validity_end'],1)); ?></div>
                        </div>
                        <div class="col-md-4 mb-3"><label for="seguro">Creado</label>
                            <div class="seguro-data"><?php echo e($this->getFecha($seguro['created_at'],1)); ?></div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-4 mb-3"><label for="birthday">Compañia</label>
                            <div class="seguro-data"><img src="<?php echo e($seguro['company']['logo_filename']); ?>"
                                    width="50px"><?php echo e($seguro['company']['name']); ?></div>
                        </div>
                        <div class="col-md-4 mb-3"><label for="gender">Precio</label>
                            <div class="seguro-data"> <?php echo e($seguro['quote']['sub_total_price_nice']); ?></div>
                        </div>

                    </div>
                </form>
            </div>




            <div class="card card-body border-0 shadow mb-4">
                <h2 class="h5 mb-4">Seguro Grupal</h2>
                <form>
                    <div class="row">
                        <div class="col-md-4 mb-3">
                            <div>
                                <label for="first_name">Numero</label>
                                <div class="seguro-data"><?php echo e($seguro['insurance']['id']); ?> - <?php echo e($seguro['insurance']['name']); ?></div>
                            </div>
                        </div>
                        <div class="col-md-4 mb-3">
                            <div>
                                <label for="last_name">Application</label>
                                <div class="seguro-data"><?php echo e($seguro['insurance']['application']['name']); ?></div>
                            </div>
                        </div>
                        <div class="col-md-4 mb-3"><label for="birthday">Precio</label>
                            <div class="seguro-data"><?php echo e($seguro['insurance']['total_nice']); ?></div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-4 mb-3"><label for="birthday">Valido desde</label>
                            <div class="seguro-data"><?php echo e($this->getFecha($seguro['insurance']['validity_start'],1)); ?></div>
                        </div>
                        <div class="col-md-4 mb-3"><label for="gender">Valido hasta</label>
                            <div class="seguro-data"><?php echo e($this->getFecha($seguro['insurance']['validity_end'],1)); ?></div>
                        </div>
                        <div class="col-md-4 mb-3"><label for="birthday">Creado</label>
                            <div class="seguro-data"><?php echo e($this->getFecha($seguro['insurance']['created_at'])); ?></div>
                        </div>
                    </div>
                </form>
            </div>






            <div class="card card-body border-0 shadow mb-4">
                <h2 class="h5 mb-4">Cobertura del seguro</h2>

                <form>
                    <div class="row">
                        <div class="col-md-4 mb-3">
                            <div>
                                <label for="first_name">Muerte</label>
                                <div class="seguro-data"><?php echo e($seguro['insurance']['coverage']['description']['death_amount_nice']); ?></div>
                            </div>
                        </div>
                        <div class="col-md-4 mb-3">
                            <div>
                                <label for="last_name">Sepelio</label>
                                <div class="seguro-data"><?php echo e($seguro['insurance']['coverage']['description']['burial_amount_nice']); ?></div>
                            </div>
                        </div>
                        <div class="col-md-4 mb-3"><label for="birthday">Invalidez</label>
                            <div class="seguro-data"><?php echo e($seguro['insurance']['coverage']['description']['disability_amount_nice']); ?></div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-4 mb-3"><label for="birthday">Gasto medico</label>
                            <div class="seguro-data"><?php echo e($seguro['insurance']['coverage']['description']['medical_expenses_amount_nice']); ?></div>
                        </div>
                        <div class="col-md-4 mb-3"><label for="birthday">Hospitalizacion</label>
                            <div class="seguro-data"><?php echo e($seguro['insurance']['coverage']['description']['hospitalization_daily_amount_nice']); ?></div>
                        </div>
                        <div class="col-md-4 mb-3"><label for="gender">Edad</label>
                            <div class="seguro-data"><?php echo e($seguro['insurance']['coverage']['description']['min_age']); ?> a <?php echo e($seguro['insurance']['coverage']['description']['max_age']); ?> años</div>
                        </div>


                    </div>

                    <div class="row">
                        <div class="col-md-4 mb-3"><label for="birthday">Deducible gasto medico</label>
                            <div class="seguro-data"><?php echo e($seguro['insurance']['coverage']['description']['deductible_medical_expenses_amount_nice']); ?></div>
                        </div>
                        <div class="col-md-4 mb-3"><label for="birthday">Deducible hospitalizacion</label>
                            <div class="seguro-data"><?php echo e($seguro['insurance']['coverage']['description']['deductible_hospitalization_daily_amount_nice']); ?></div>
                        </div>

                        <div class="col-md-4 mb-3"><label for="birthday">Alcance</label>
                            <div class="seguro-data"><?php echo e($seguro['insurance']['coverage']['description']['scope']); ?></div>
                        </div>

                    </div>

                </form>


            </div>


















        </div>
        <div class="col-12 col-xl-4">
            <div class="row">

                <div class="col-12">
                    <div class="card card-body border-0 shadow mb-4">
                        <h2 class="h5 mb-4">Datos del asegurado</h2>
                        <div class="d-flex align-items-center">
                            <div class="me-3"> <img class="rounded avatar-xl"
                                    src="<?php echo e($seguro['insured_entity']['avatar']); ?>" alt="change avatar"></div>
                            <div class="file-field">
                                <div class="d-flex justify-content-xl-center ms-xl-3">
                                    <div class="d-flex">
                                        <div class="d-md-block text-left">
                                            <div class="fw-normal text-dark mb-1">Nombre</div>
                                            <div class="text-gray small"><?php echo e($seguro['insured_entity']['name_nice']); ?>

                                            </div>
                                            <div class="fw-normal text-dark mb-1">Documento</div>
                                            <div class="text-gray small">
                                                <?php echo e($seguro['insured_entity']['document_nice']); ?></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>



                <div class="col-12">
                    <div class="card card-body border-0 shadow mb-4">
                        <h2 class="h5 mb-4">Datos del asegurador</h2>
                        <div class="d-flex align-items-center">
                            <div class="me-3"> <img class="rounded avatar-xl"
                                    src="<?php echo e($seguro['creator_entity']['avatar']); ?>" alt="change avatar"></div>
                            <div class="file-field">
                                <div class="d-flex justify-content-xl-center ms-xl-3">
                                    <div class="d-flex">
                                        <div class="d-md-block text-left">
                                            <div class="fw-normal text-dark mb-1">Nombre</div>
                                            <div class="text-gray small"><?php echo e($seguro['creator_entity']['name_nice']); ?>

                                            </div>
                                            <div class="fw-normal text-dark mb-1">Documento</div>
                                            <div class="text-gray small">
                                                <?php echo e($seguro['creator_entity']['document_nice']); ?></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>


            </div>
        </div>
    </div>
</div>
<?php /**PATH C:\home\mecubro-admin.local\resources\views/livewire/seguros/segurosficha.blade.php ENDPATH**/ ?>