<div>
<title>Tacticas y estrategias | Criptobots.com</title>
    <style>
        .titulos {
            font-weight: bold;
            color: #f00;
        }

        .cont-item {
            margin-right: 10px;        
            width: calc(100% / 6 - 10px); /* Ancho para ocupar 1/6 de la pantalla y dejar margen */
        }

        .empty-tactica {
            width: calc(100% / 6 - 10px); /* Ancho para el espacio de tácticas sin título */
            height: 1px; /* Altura mínima para que ocupe espacio sin afectar la visualización */
        }

        /* Colores de borde según la estrategia del item */
        .comprar {
            border-color: green;
        }

        .vender {
            border-color: red;
        }

        /* Estilo para el div del primer item de cada táctica */
        .titulo-tactica {
            background-color: #f00; /* Color brillante */
            width: 8px; /* Ancho de 8px para mostrarlo como separador */
            margin-bottom: 5px; /* Margen inferior para separar el título de los items */
            color: transparent; /* Oculta el texto */
        }

        /* Estilo para los items que no son el primer item de cada táctica */
        .item-no-titulo {
            margin-top: 15px; /* Margen superior para separar los items */
        }

        /* Estilo para los items sin título de táctica */
        .item-sin-titulo {
            margin-top: 15px; /* Margen superior para separar los items */
            visibility: hidden; /* Oculta el contenido, pero mantiene el espacio */
        }

        /* Estilo para las opciones de cada item */
        .cont-opciones {
            text-align: center;
            font-size: 14px; /* Tamaño de fuente de las opciones */
        }

        /* Estilo para el separador de táctica */
        .tactica-separador {
            background: #3d3d3d;
            color: #fff;
            text-align: center;
            font-size: 20px;
            letter-spacing: 0.6px;
        }
        .card-body{
            padding: 5px;
        }
        .verde{
            color:#008b00;
            font-weight: bold;
        }
        .minutos{
            background-color: #FFE6E6;
        }
        .horas{
            background-color: #FFCCCC;
        }
        .dias{
            background-color: #FFC0CB;
        }
        .otros{
            background-color: #FFB3B3;
        }
    </style>

    <div class="row">
        <p>    
            <?php if(isset($dataTacticas['timestamp'])): ?>
                <p>Última actualización: <?php echo e(date('d-m-Y H:i:s', $dataTacticas['timestamp'])); ?> <strong><?php echo e($txtActualizado); ?></strong></p>
            <?php else: ?>
            <p>No hay datos disponibles</p>
            <?php endif; ?></p>
        <div class="col-12">
            <div class="d-flex flex-wrap">
                <?php
                    $tacticaActual = null;
                ?>
                <?php $__currentLoopData = $dataTacticas['comprar']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tactica): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if(isset($tactica['nombre']) && $tacticaActual != $tactica['nombre']): ?>
                        <?php
                            $tacticaActual = $tactica['nombre'];
                        ?>
                    <?php endif; ?>

                    <?php if(isset($tactica['items']) && is_array($tactica['items']) && count($tactica['items']) > 0): ?>
                        <?php $__currentLoopData = $tactica['items']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $itemId=>$item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                        <?php
                        $opcionesOrdenados = collect($item['opciones'])->sortBy('periodo')->values();

                        $opcionesOrdenados = collect($item['opciones'])->sortBy(function ($opcion) {
                            // Definir un valor numérico para cada categoría
                            switch ($opcion['periodo']) {
                                case 'minutos':
                                    return 1;
                                case 'horas':
                                    return 2;
                                case 'dias':
                                    return 3;
                                case 'otros':
                                    return 4;                                    
                                default:
                                    return 5;
                            }
                        })->values(); 
                        
                        ?>

                            <div class="cont-item <?php if(!$loop->first): ?> item-no-titulo <?php endif; ?> <?php if(isset($item['estrategia'])): ?><?php echo e($item['estrategia']); ?><?php endif; ?>">
                                <?php if($loop->first): ?>
                                    <div class="card mb-2">
                                        <div class="card-body">
                                            <div class="tactica-separador"><?php echo e($tacticaActual); ?></div>
                                                                                  
                                             <?php echo e($item['nombre']); ?> (<?php echo e(isset($dataTacticas['comprar']['puntajes'][$itemId]['puntaje']) ? $dataTacticas['comprar']['puntajes'][$itemId]['puntaje'] : 'N/A'); ?> de <?php echo e(isset($dataTacticas['comprar']['puntajes'][$itemId]['cant_opciones']) ? $dataTacticas['comprar']['puntajes'][$itemId]['cant_opciones'] : 'N/A'); ?>)                                            

                                            <?php $__currentLoopData = $opcionesOrdenados; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $opcion): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="cont-opciones <?php echo e($opcion['periodo']); ?> <?php if($opcion['puntaje']==1): ?>verde <?php endif; ?>">
                                                    <?php echo e($opcion['txt']); ?>

                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                    </div>
                                <?php else: ?>
                                    <div class="card mb-2">
                                        <div class="card-body">
                                            <div class="tactica-separador"></div>
                                                       
                                            <?php echo e($item['nombre']); ?> (<?php echo e(isset($dataTacticas['comprar']['puntajes'][$itemId]['puntaje']) ? $dataTacticas['comprar']['puntajes'][$itemId]['puntaje'] : 'N/A'); ?> de <?php echo e(isset($dataTacticas['comprar']['puntajes'][$itemId]['cant_opciones']) ? $dataTacticas['comprar']['puntajes'][$itemId]['cant_opciones'] : 'N/A'); ?>)                                            
                                            <?php $__currentLoopData = $opcionesOrdenados; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $opcion): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="cont-opciones <?php echo e($opcion['periodo']); ?> <?php if($opcion['puntaje']==1): ?>verde <?php endif; ?>">
                                                    <?php echo e($opcion['txt']); ?>

                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>
                        <div class="cont-item item-sin-titulo">
                            <div class="tactica-separador">&nbsp;</div>
                            <div class="card mb-2">
                                <div class="card-body">
                                    &nbsp;
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                <!-- Espacio para tácticas sin título -->
                <div class="cont-item col-auto empty-tactica"></div>
            </div>
        </div>
    </div>
    <div wire:poll.3000ms="pollDataTacticas"></div>
</div>


<?php /**PATH C:\home\front.criptobots\resources\views/livewire/tacticas/tacticas.blade.php ENDPATH**/ ?>