<div>
    <title>Exchange | Criptobots.com</title>
    <style>
        /* Posicionar los contenedores de los gráficos secundarios debajo de los otros gráficos */
        #minutosSec,
        #horasSec,
        #diasSec {
            position: relative;
        }

        .graficos {
            position: relative;
        }


        .minuto-amp {
            display: block;
        }

        .minuto-amp-sec {
            display: block;
        }

        .canvasjs-chart-toolbar {
            right: 200px !important;
        }

        .minuto {}

        .minuto-sec2 {
            top: -100px;
        }

        .hora2 {
            top: -180px;
        }

        .hora-sec2 {
            top: -240px;
        }

        .dia2 {
            top: -260px;
        }

        .dia-sec2 {
            top: -300px;
        }
    </style>
    <div class="demo">
        <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('mini-cot-panel', ['id_moneda' => $this->id_moneda])->html();
} elseif ($_instance->childHasBeenRendered('l3194380344-0')) {
    $componentId = $_instance->getRenderedChildComponentId('l3194380344-0');
    $componentTag = $_instance->getRenderedChildComponentTagName('l3194380344-0');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('l3194380344-0');
} else {
    $response = \Livewire\Livewire::mount('mini-cot-panel', ['id_moneda' => $this->id_moneda]);
    $html = $response->html();
    $_instance->logRenderedChild('l3194380344-0', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
        <label for="showUnPunto">En curso</label>
        <input type="checkbox" id="showUnPunto" checked>

        <label for="showDosPuntos">Finalizadas</label>
        <input type="checkbox" id="showDosPuntos" checked>
        <div id="cont-charts">
            <div class="graficos minuto-amp" id="minutosAmplio" style="height: 300px; width: 100%;"></div>
            <div class="graficos minuto-amp-sec" id="minutosAmplioSec" style="height: 200px; width: 100%;"></div>
            <div class="graficos2 minuto-macdh" id="minutosMacdH" style="height: 200px; width: 100%"></div>

            <div class="graficos minuto" id="minutos" style="height: 300px; width: 100%;"></div>
            <div class="graficos minuto-sec" id="minutosSec" style="height: 200px; width: 100%;"></div>

            <div class="graficos hora" id="horas" style="height: 300px; width: 100%;"></div>
            <div class="graficos hora-sec" id="horasSec" style="height: 200px; width: 100%;"></div>

            <div class="graficos dia" id="dias" style="height: 300px; width: 100%;"></div>
            <div class="graficos dia-sec" id="diasSec" style="height: 200px; width: 100%;"></div>
        </div>
    </div>

    <script src="/assets/canvas/canvasjs.min.js"></script>



    <script>
        var minutosAmplioSecChart, minutosSecChart, horasSecChart, diasSecChart, minutosMacdH;
        var mainCharts = [];
        window.onload = function() {
            var chartMinutosAmplio = generateChart('minutosAmplio');
            chartMinutosAmplio.render();
            mainCharts.push(chartMinutosAmplio);

            var chartMinutos = generateChart('minutos');
            chartMinutos.render();
            mainCharts.push(chartMinutos);

            var chartHoras = generateChart('horas');
            chartHoras.render();
            mainCharts.push(chartHoras);

            var chartDias = generateChart('dias');
            chartDias.render();
            mainCharts.push(chartDias);

            // Crear y renderizar el gráfico secundario de columna después de que los contenedores de los gráficos principales estén disponibles en el DOM
            minutosAmplioSecChart = generateColumnChart('minutosAmplioSec');
            minutosAmplioSecChart.render();

            minutosSecChart = generateColumnChart('minutosSec', 'minutosSecMACD');
            minutosSecChart.render();

            horasSecChart = generateColumnChart('horasSec', 'horasSecMACD');
            horasSecChart.render();

            diasSecChart = generateColumnChart('diasSec');
            diasSecChart.render();

            minutosMacdH = generateColumnChart('minutosMacdH', 'horasSec');
            minutosMacdH.render();

            updateChart(chartMinutosAmplio, 'm', minutosAmplioSecChart);
            updateChart(chartMinutos, 'm', minutosSecChart);
            updateChart(chartHoras, 'h', horasSecChart);
            updateChart(chartDias, 'd', diasSecChart);

            // Obtener referencias a los controles de mostrar/ocultar
            var showUnPuntoCheckbox = document.getElementById('showUnPunto');
            var showDosPuntosCheckbox = document.getElementById('showDosPuntos');




            // Función para manejar los cambios en los checkboxes
            function handleCheckboxChange() {
                var showUnPunto = showUnPuntoCheckbox.checked;
                var showDosPuntos = showDosPuntosCheckbox.checked;

                mainCharts.forEach(chart => {
                    chart.options.data.forEach(series => {
                        if (series.name === 'Operaciones (Un Punto)') {
                            series.visible = showUnPunto;
                        }
                        if (series.name.startsWith('Operación #')) {
                            series.visible = showDosPuntos;
                        }
                    });
                    chart.render();
                });
            }

            showUnPuntoCheckbox.addEventListener('change', handleCheckboxChange);
            showDosPuntosCheckbox.addEventListener('change', handleCheckboxChange);

        }


     

        function updateChart(chart, letra, secChart) {
    var periodo = chart.periodo;
    $.ajax({
        type: 'GET',
        url: '/get_chart_data/<?php echo e($id_moneda); ?>/' + letra,
        data: { periodo: periodo },
        dataType: 'json',
        success: function(info) {
            var datos = info.velas;
            var ordenes = info.ordenes;
            var finalizadas = info.finalizadas;

            var mainDataPoints = [];
            var macdDataPoints = [];
            var ema8DataPoints = [];
            var ema21DataPoints = [];
            var ema200DataPoints = [];

            Object.values(datos).forEach((dataPoint) => {
                var xValue = new Date(dataPoint.fecha_vela);
                var mainYValues = [parseFloat(dataPoint.open), parseFloat(dataPoint.high),
                    parseFloat(dataPoint.low), parseFloat(dataPoint.close)
                ];

                var ema8Value = parseFloat(dataPoint.ema8);
                var ema21Value = parseFloat(dataPoint.ema21);
                var ema200Value = parseFloat(dataPoint.ema200);

                mainDataPoints.push({
                    x: xValue,
                    y: mainYValues,
                    label2: dataPoint.fecha_stats + ' ' + dataPoint.hora_stats,
                });

                var macdValue = parseFloat(dataPoint.macd);
                var color = macdValue > 0 ? "green" : "red";

                macdDataPoints.push({
                    x: xValue,
                    y: macdValue,
                    color: color,
                });

                ema8DataPoints.push({
                    x: xValue,
                    y: ema8Value
                });
                ema21DataPoints.push({
                    x: xValue,
                    y: ema21Value
                });
                ema200DataPoints.push({
                    x: xValue,
                    y: ema200Value
                });
            });

            var operacionesSeriesIndex = chart.options.data.findIndex(series => series.name === 'Operaciones');
            if (operacionesSeriesIndex !== -1) {
                chart.options.data.splice(operacionesSeriesIndex, 1);
            }

            var showUnPunto = $("#showUnPunto:checked").length > 0;
            if (showUnPunto) {
                var operacionesDataPoints = Object.values(ordenes).map(orden => {
                    var fechaCreacion = new Date(orden.fecha_creacion);
                    var fechaCreacionTimestamp = fechaCreacion.getTime();

                    if (fechaCreacionTimestamp >= chart.axisX[0].viewportMinimum &&
                        fechaCreacionTimestamp <= chart.axisX[0].viewportMaximum) {
                        return {
                            x: fechaCreacion.getTime(),
                            y: parseFloat(orden.price),
                            markerType: 'triangle',
                            markerSize: 16,
                            className: 'custom-marker',
                            axisYType: 'secondary',
                            label: 'En curso #' + orden.id_orden + '<br>' + fechaCreacion +
                                '<br>$' + orden.price + '(' + orden.ganancia_porc + '%)',
                            markerColor: (orden.estado === '2') ? 'darkgreen' : (orden.estado === '1') ? 'lightgreen' : 'purple',
                                 // markerColor: orden.estado === '1' ? 'lightgreen' : 'darkgreen',                            
                        };
                    } else {
                        return null;
                    }
                }).filter(dataPoint => dataPoint !== null);

                var nuevaOperacionesSeries = {
                    type: 'scatter',
                    name: 'Operaciones',
                    dataPoints: operacionesDataPoints,
                    toolTipContent: "{label}",
                };

                chart.options.data.push(nuevaOperacionesSeries);
            }

            chart.options.data = chart.options.data.filter(series => !series.name.startsWith('Operación #'));

            var showDosPuntos = $("#showDosPuntos:checked").length > 0;
            if (showDosPuntos) {
                Object.values(finalizadas).forEach(orden => {
                    var fechaCreacion = new Date(orden.fecha_creacion);
                    var fechaCreacionTimestamp = fechaCreacion.getTime();

                    if (fechaCreacionTimestamp >= chart.axisX[0].viewportMinimum &&
                        fechaCreacionTimestamp <= chart.axisX[0].viewportMaximum) {
                        var compraDataPoint = {
                            x: fechaCreacion.getTime(),
                            y: parseFloat(orden.price),
                            markerType: 'triangle',
                            markerSize: 16,
                            className: 'custom-marker',
                            axisYType: 'secondary',
                            markerColor: (orden.estado === 4 || orden.estado === 2) ? 'green' : (orden.estado === -1) ? 'violet' : 'grey',
                            label: `Finalizada #${orden.id_orden}<br>$${orden.price}<br>${fechaCreacion.toISOString().split('T')[0]}`,
                        };

                        if (orden.fecha_finalizada) {
                            var fechaFinalizada = new Date(orden.fecha_finalizada);
                            var fechaFinalizadaTimestamp = fechaFinalizada.getTime();

                            if (fechaFinalizadaTimestamp >= chart.axisX[0].viewportMinimum &&
                                fechaFinalizadaTimestamp <= chart.axisX[0].viewportMaximum) {
                                var finalizacionDataPoint = {
                                    x: fechaFinalizada.getTime(),
                                    y: parseFloat(orden.vender_precio || orden.cancelar),
                                    markerType: 'circle',
                                    markerSize: 16,
                                    className: 'custom-marker',
                                    axisYType: 'secondary',
                                    markerColor: orden.estado === '1' ? 'lightblue' : 'blue',
                                    label: `Finaliazada #${orden.id_orden}<br>$${orden.vender_precio || orden.cancelar}<br>${fechaFinalizada.toISOString().split('T')[0]}`,
                                };

                                var operacionesDosPuntosSeries = {
                                    type: 'line',
                                    name: `Operación #${orden.id_orden}`,
                                    dataPoints: [compraDataPoint, finalizacionDataPoint],
                                };

                                chart.options.data.push(operacionesDosPuntosSeries);
                            }
                        }
                    }
                });
            }

            chart.options.data[1].dataPoints = ema8DataPoints;
            chart.options.data[2].dataPoints = ema21DataPoints;
            chart.options.data[3].dataPoints = ema200DataPoints;

            chart.options.data[0].dataPoints = mainDataPoints;
            chart.render();


            secChart.options.data[0].dataPoints = macdDataPoints;
            secChart.render();
    
            if (letra === 'h') {
                console.log(minutosMacdH);
                minutosMacdH.options.data[0].dataPoints = macdDataPoints;
                minutosMacdH.render();
            }            


            var tiempoActualizacion = 6000;
            if (periodo === 'horas') {
                tiempoActualizacion = 60000 * 10;
            } else if (periodo === 'dias') {
                tiempoActualizacion = 60000 * 60;
            }

            setTimeout(function() {
                updateChart(chart, letra, secChart);
            }, tiempoActualizacion);
        },
        error: function(xhr, status, error) {
            console.error("Error en la llamada a la API:", error);
            setTimeout(function() {
                updateChart(chart, letra, secChart);
            }, 5000);
        }
    });
}
      



   

        function generateChart(periodo) {
            var containerId = periodo; // Construimos el containerId usando el periodo
            var fechas = calcularFechasUltimasHoras(8);
            var chartOptions = {
                animationEnabled: false,
                theme: "light2",
                axisY: {
                    gridThickness: 0,
                    tickLength: 0,
                    lineThickness: 0,
                    includeZero: false,
                    prefix: "$",
                    labelFormatter: function() {
                        return "";
                    }
                },
                axisY2: {
                    includeZero: false,
                    prefix: "",
                    labelFormatter: function() {
                        return "";
                    }
                },
                toolTip: {
                    shared: true
                },
                legend: {
                    reversed: true,
                    cursor: "pointer",
                    itemclick: toggleDataSeries
                },
                zoomEnabled: true,
                zoomType: "x",
                data: [{
                        click: function(e) {
                            valor1 = parent.document.getElementById("calc1").innerHTML
                            valor2 = parent.document.getElementById("calc2").innerHTML;
                            datos = e.dataPoint.y;
                            val_close = datos[3];

                            if (valor1 == '0') {
                                parent.document.getElementById("calc1").innerHTML = val_close;
                            } else {
                                if (valor2 == '0') {
                                    parent.document.getElementById("calc2").innerHTML = val_close;
                                    dif = parseFloat(val_close) - parseFloat(valor1);
                                    resultado = (dif / val_close) * 100;
                                    parent.document.getElementById("calc-result").innerHTML = resultado
                                        .toFixed(3) + '%';
                                } else {
                                    parent.document.getElementById("calc1").innerHTML = val_close;
                                    parent.document.getElementById("calc2").innerHTML = '0';
                                }
                            }
                        },
                        <?php echo $formato_x; ?>

                        type: "candlestick",
                        showInLegend: true,
                        risingColor: "#26bd02",
                        fallingColor: "#f00",
                        name: "Cotizacion",
                        yValueFormatString: "$#,##0.000",
                        dataPoints: []
                    },
                    {
                        <?php echo $formato_x; ?>

                        type: "line",
                        color: "#26bd02",
                        showInLegend: true,
                        name: "EMA8",
                        yValueFormatString: "$#,##0.000",
                        dataPoints: [], // Aquí se llenarán los puntos de datos de la línea EMA8
                        markerType: "none",
                        color: "blue" // Color de la línea EMA8
                    },
                    {
                        <?php echo $formato_x; ?>

                        type: "line",
                        color: "#f00",
                        showInLegend: true,
                        yValueFormatString: "$#,##0.000",
                        showInLegend: true,
                        name: "EMA21",
                        markerType: "none",
                        dataPoints: [], // Aquí se llenarán los puntos de datos de la línea EMA21

                    },
                    {
                        <?php echo $formato_x; ?>

                        type: "line",
                        color: "#000",
                        showInLegend: true,
                        yValueFormatString: "$#,##0.000",
                        showInLegend: true,
                        name: "EMA200",
                        markerType: "none",
                        dataPoints: [], // Aquí se llenarán los puntos de datos de la línea EMA200
                    }
                ]
            };

            // Agregar el eje X si el periodo es 'minutosAmplio'
            if (periodo === 'minutosAmplio') {
                chartOptions.axisX = {
                    viewportMinimum: new Date(fechas.fechaLimiteInferiorStr),
                    viewportMaximum: new Date(fechas.fechaActualStr)
                };
            }


            return new CanvasJS.Chart(containerId, chartOptions);
        }

        function generateColumnChart(periodo, chartIdentifier) {
            console.log(periodo);
            var containerId = periodo; // Construimos el containerId usando el periodo
            var fechas = calcularFechasUltimasHoras(18);
            var chartOptions = {
                animationEnabled: true,
                theme: "light2", // "light1", "light2", "dark1", "dark2"
                axisY: {
                    includeZero: false,
                    prefix: "",
                    labelFormatter: function() {
                        return "";
                    }
                },
                axisY2: {
                    includeZero: false,
                    prefix: "",
                    labelFormatter: function() {
                        return "";
                    }
                },
                toolTip: {
                    shared: true
                },
                legend: {
                    display: false,
                    cursor: "pointer",
                    itemclick: toggleDataSeries
                },
                zoomEnabled: true,
                zoomType: "x",
                data: [{
                    <?php echo $formato_x; ?>

                    type: "column",
                    dataPoints: [],
                    showInLegend: true,
                    color: "green",
                    name: "MACD",
                    yValueFormatString: "#,##0.00000000",
                }]
            };
            // Agregar el eje X si el periodo es 'minutosAmplio'
            if (periodo === 'minutosAmplioSec') {
                chartOptions.axisX = {
                    viewportMinimum: new Date(fechas.fechaLimiteInferiorStr),
                    viewportMaximum: new Date(fechas.fechaActualStr)
                };
            }
            

                // Sincronizar el gráfico MACD de minutos con el gráfico principal
            if (periodo === 'minutosMacdH' || periodo === 'horasSecMACD') {
                console.log('***adentro');
                chartOptions.axisX = {
                    viewportMinimum: new Date(fechas.fechaLimiteInferiorStr),
                    viewportMaximum: new Date(fechas.fechaActualStr)
                };                
                //chart.options.data[0].dataPoints = chartOptions.data[0].dataPoints;
            }


            var chart = new CanvasJS.Chart(containerId, chartOptions);                       
            return chart;
        }

        function toggleDataSeries(e) {
            if (typeof(e.dataSeries.visible) === "undefined" || e.dataSeries.visible) {
                e.dataSeries.visible = false;
            } else {
                e.dataSeries.visible = true;
            }
            e.chart.render();
        }


        function calcularFechasUltimasHoras(cantidadHoras) {
            var fechaActual = new Date();
            var fechaLimiteInferior = new Date(fechaActual.getTime() - (cantidadHoras * 60 * 60 * 1000));
            var fechaActualStr = fechaActual.toISOString().slice(0, 19).replace('T', ' ');
            var fechaLimiteInferiorStr = fechaLimiteInferior.toISOString().slice(0, 19).replace('T', ' ');

            return {
                fechaActualStr: "2029-3-18 19:45", //fechaActualStr,
                fechaLimiteInferiorStr: fechaLimiteInferiorStr
            };
        }
    </script>


</div>
<?php /**PATH C:\home\front.criptobots\resources\views/livewire/exchange/exchange.blade.php ENDPATH**/ ?>