<?php

use App\Http\Livewire\Dashboard;
use App\Http\Livewire\Err404;
use App\Http\Livewire\Err500;

use App\Http\Livewire\Auth\Login;
use App\Http\Livewire\Profile;
use App\Http\Livewire\ForgotPassword;

use App\Http\Livewire\Index;
use App\Http\Livewire\Logout;
use Illuminate\Support\Facades\Route;

use App\Http\Livewire\Siniestros\Siniestros;

use App\Http\Livewire\Soporte\Soporte;
use App\Http\Livewire\Exchange\Exchange;
use App\Http\Livewire\Tacticas\Tacticas;
use App\Http\Livewire\Data\Data;
use App\Http\Livewire\Emulador\Emulador; 


use App\Http\Controllers\ChartController;

Route::get('/get_chart_data/{id}/{periodo}', [ChartController::class, 'getChartData']);
Route::get('/get_estrategias', [ChartController::class, 'getEstrategias']);
Route::get('/get_estrategias/{id}', [ChartController::class, 'getCoinEstrategia']);
Route::redirect('/', '/login');

Route::get('/login', Login::class)->name('login');
Route::get('/logout', Logout::class)->name('logout');


Route::get('/404', Err404::class)->name('404');
Route::get('/500', Err500::class)->name('500');





Route::middleware('auth')->group(function () {
    Route::get('/dashboard', Dashboard::class)->name('dashboard');
    Route::get('/exchange/{id}', Exchange::class)->name('exchange');
    Route::get('/tacticas/{id}', Tacticas::class)->name('tacticas');
    Route::get('/data/{id}', Data::class)->name('data');
    Route::get('/emulador/{id}', Emulador::class)->name('emulador');
    

    Route::get('/soporte', Soporte::class)->name('soporte');

    Route::get('/siniestros', Siniestros::class)->name('siniestros');



    


    Route::get('/profile', Profile::class)->name('profile');


    Route::get('/forgot-password', ForgotPassword::class)->name('forgot-password');
});
