<div>
    <title>MeCubro | Centro de soporte</title>
    <div class="row align-items-start">
        <div class="col-8" wire:poll.9000ms>
            <div class="d-flex justify-content-between w-100 flex-wrap">
                <div class="mb-3 mb-lg-0">
                    <h1 class="h4">{{ $siniestro['details'] }} 0 Archivo/s enviados)</h1>
                </div>
                <div><a href="/siniestros" class="btn btn-outline-gray-600 d-inline-flex align-items-center">Volver</a>
                </div>
            </div>

            @foreach ($siniestroMensajes as $mensaje)
                @if ($mensaje['is_owner']==0)
                    <div class="card border-0 shadow p-2 mb-2">
                        <div class="d-flex justify-content-between align-items-center mb-1">
                            <span class="font-small">
                                <a href="#">
                                    <img class="avatar-sm img-fluid rounded-circle me-2"
                                        src="https://ui-avatars.com/api/?background=random&rounded=true&bold=true&name={{ $mensaje['creator_entity']['name_nice'] }}"
                                        alt="avatar">
                                    <span class="fw-bold">{{ $mensaje['creator_entity']['name_nice'] }}</span>
                                </a>
                                <span class="fw-normal ms-2">{{ $this->getFecha($mensaje['created_at'],1) }}</span>
                            </span>
                        </div>
                        <p class="m-0">{{ $mensaje['message'] }}.</p>
                    </div>
                @else
                    <div class="card bg-gray-800 text-white border-0 shadow p-2 ms-md-5 ms-lg-6 mb-2">
                        <div class="d-flex justify-content-between align-items-center mb-2">
                            <span class="font-small">
                                <span class="fw-bold">Respondiste</span>
                                <span class="fw-normal text-gray-300 ms-2">{{ $this->getFecha($mensaje['created_at'],1) }}</span>
                            </span>
                        </div>
                        <p class="text-gray-300 m-0">{{ $mensaje['message'] }}</p>
                    </div>
                @endif
            @endforeach

            <form class="mt-4" wire:submit.prevent="save" action="#" method="POST">
                <textarea wire:model="msg" class="form-control border-0 shadow mb-4" id="message"
                    placeholder="Responder ticket de soporte" rows="6" maxlength="1000" required=""></textarea>
                <div class="d-flex justify-content-between align-items-center mt-3">
                    <div class="file-field">

                    </div>
                    <div>
                        <button type="submit" class="btn btn-secondary d-inline-flex align-items-center text-dark">
                            <svg class="icon icon-xs me-2" fill="currentColor" viewBox="0 0 20 20"
                                xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd"
                                    d="M7.707 3.293a1 1 0 010 1.414L5.414 7H11a7 7 0 017 7v2a1 1 0 11-2 0v-2a5 5 0 00-5-5H5.414l2.293 2.293a1 1 0 11-1.414 1.414l-4-4a1 1 0 010-1.414l4-4a1 1 0 011.414 0z"
                                    clip-rule="evenodd"></path>
                            </svg> Responder
                        </button>
                    </div>
                </div>
            </form>

            @if ($claimFiles >= 1)
                @foreach ($claimFiles as $file)
                    <div style="max-width:220px" class="claim-chat-files-cont">
                        <div style="text-align:right" class="claim-chat-files-title">
                            <div wire:loading wire:target="attachDelete({{ $file['id'] }})"
                                class="clear claim-chat-files-delete">Eliminando...</div>
                            <a wire:click="attachDelete({{ $file['id'] }})"
                                onclick="confirm('¿Seguro que quieres eliminar?') || event.stopImmediatePropagation()">X</a>
                        </div>
                        <div>
                            <a href="{{ $file['links']['download'] }}" target="new">
                            <img src="{{ $file['links']['download'] }}" onerror="this.src = '/assets/img/sf.jpg';"
                                style="max-width:200px; max-height:200px">
                            </a>
                        </div>
                        <div style="padding:10px 0px">
                            <div class="claim-chat-files-inf">
                                {{ $file['type'] }}
                            </div>
                        </div>
                    </div>
                @endforeach
            @endif

            <div wire:loading wire:target="attach" class="clear">Cargando...</div>
            @if ($attach)
                <div style="max-width:300px" class="claim-chat-files-cont clear">
                    <div>
                        <img src="{{ $attach->temporaryUrl() }}" style="max-width:300px; max-height:300px">
                    </div>
                    <div style="padding:10px 0px">
                        <div>
                            <select name="documment-types" wire:model="attachType" style="width:100%">
                                <option value="medical_certificate">Certificado Medico</option>
                                <option value="clinical_history">Historia Clinica</option>
                                <option value="document_front">Documento - Frente</option>
                                <option value="document_back">Documento - Atras</option>
                                <option value="bank_account_certificate">Certificado - Cuenta bancaria</option>
                                <option value="clinical_analysis">Analisis Clinico</option>
                                <option value="certificate_of_death">Certificado Defuncion</option>
                                <option value="others">Otros</option>
                            </select>
                        </div>
                        <div style="text-align:right">
                            @if ($fileSend)
                                <div>Enviada correctamente</div>
                            @else
                                <a wire:click="attachTmpDelete"><strong>X</strong> Quitar</a>
                            @endif

                        </div>
                    </div>
                    <div>
                        <div wire:loading wire:target="attachSend" class="clear">Enviando Archivo...</div>
                        <button value="Enviar Documento" wire:click="attachSend" style="width:100%">Enviar
                            Documento</button>
                    </div>
                </div>
            @else
                <div class="clear">
                    <div class="d-flex align-items-center">
                        <h3>Añadir archivos</h3>
                        <svg class="icon icon-md text-gray-400 me-3" fill="currentColor" viewBox="0 0 20 20"
                            xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd"
                                d="M8 4a3 3 0 00-3 3v4a5 5 0 0010 0V7a1 1 0 112 0v4a7 7 0 11-14 0V7a5 5 0 0110 0v4a3 3 0 11-6 0V7a1 1 0 012 0v4a1 1 0 102 0V7a3 3 0 00-3-3z"
                                clip-rule="evenodd"></path>
                        </svg>
                        <input type="file" wire:model="attach" style="max-width: 230px;position: absolute;cursor: pointer;opacity: 0; padding-bottom: 30px;">
                        @error('file')
                            <span class="error">Error al cargar archivo</span>
                        @enderror
                    </div>
                    <div class="text-gray small pe-3 pe-lg-11 d-none d-md-inline">
                        <strong>Enviar Archivo </strong> jpg, jpeg, png, doc, pdf.
                    </div>
                </div>
            @endif
        </div>

        <div class="col-4">
            <div class="card card-body border-0 shadow mb-4">
                <h2 class="h5 mb-4">Reclamo # {{ $siniestro['id']}}</h2>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <div>
                                <label for="first_name">Tipo de riesgo</label>
                                <div class="seguro-data">{{ $siniestro['risk_type']['name'] }} </div>
                            </div>
                        </div>
                        <div class="col-md-6 mb-3">
                            <div>
                                <label for="last_name">Fecha Ocurrencia</label>
                                <div class="seguro-data">{{ $this->getFecha($siniestro['date']) }} - {{ $siniestro['hour'] }}</div>
                            </div>
                        </div>
                        <div class="col-md-6 mb-3"><label>Estado</label>
                            <div class="seguro-data">{{ $siniestro['status_nice'] }}</div>
                        </div>

                        <div class="col-md-6 mb-3">
                            <label>Reclamos previos</label>
                            <div class="seguro-data">{{ $siniestro['previous_claim_nice'] }}</div>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label>Fecha notificacion</label>
                            <div class="seguro-data">{{ $siniestro['last_date_notify'] }}</div>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label>Cant. notificaciones</label>
                            <div class="seguro-data">{{ $siniestro['notify_times'] }}</div>
                        </div>
                         <div class="col-md-6 mb-3">
                            <label>creado</label>
                            <div class="seguro-data">{{ $this->getFecha($siniestro['created_at'],1) }}</div>
                        </div>
                    </div>
            </div>
            <div class="card card-body border-0 shadow mb-4">
                <h2 class="h5 mb-4">Relato</h2>
                    <div class="row">
                        {{ $siniestro['details'] }}
                    </div>
            </div>
            <div class="card card-body border-0 shadow mb-4">
                <h2 class="h5 mb-4">Asegurado #{{ $siniestro['insurance_risk']['insured_entity']['id']}}</h2>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <div>
                                <label for="first_name">Asegurado</label>
                                <div class="seguro-data">{{ $siniestro['insurance_risk']['insured_entity']['name_nice'] }} </div>
                            </div>
                        </div>
                        <div class="col-md-6 mb-3">
                            <div>
                                <label for="last_name">Documento</label>
                                <div class="seguro-data">{{ $siniestro['insurance_risk']['insured_entity']['document_nice'] }}</div>
                            </div>
                        </div>
                        <div class="col-md-6 mb-3"><label>Fecha nacimiento</label>
                            <div class="seguro-data">{{ $this->getFecha($siniestro['insurance_risk']['insured_entity']['birthday']) }}</div>
                        </div>

                         <div class="col-md-6 mb-3">
                            <label>Tipo</label>
                            <div class="seguro-data">{{ $siniestro['insurance_risk']['insured_entity']['entity_type']['name'] }}</div>
                        </div>
                        <div class="col-md-4 mb-3">
                            <div>
                                <label for="first_name">Actividad</label>
                                <div class="seguro-data">{{ $siniestro['insurance_risk']['risk']['risk_sub_type']['name'] }}</div>
                            </div>
                        </div>
                    </div>
            </div>


            <div class="card card-body border-0 shadow mb-4">
                <h2 class="h5 mb-4">Ubicacion</h2>
                    <div class="row">

                        <div class="col-md-4 mb-3">
                            <div>
                                <label for="last_name">Lugar</label>
                                <div class="seguro-data">{{ $siniestro['location'] }}</div>
                            </div>
                        </div>
                        <div class="col-md-4 mb-3">
                            <div>
                                <label for="last_name">Ciudad</label>
                                <div class="seguro-data">{{ $siniestro['city'] }}</div>
                            </div>
                        </div>
                        <div class="col-md-4 mb-3">
                            <div>
                                <label for="last_name">Provincia</label>
                                <div class="seguro-data">{{ $siniestro['state']['name'] }}</div>
                            </div>
                        </div>
                        <div class="col-md-4 mb-3"><label>Cargado por</label>
                            <div class="seguro-data">{{ $siniestro['creator_entity']['name_nice'] }}</div>
                        </div>
                        <div class="col-md-4 mb-3">
                            <div>
                                <label for="last_name">Pais</label>
                                <div class="seguro-data">{{ $siniestro['country']['name'] }}</div>
                            </div>
                        </div>
                    </div>
            </div>



            <div class="card card-body border-0 shadow mb-4">
                <h2 class="h5 mb-4">Preguntas</h2>
                    <div class="row">


                        @foreach ( $siniestro['description'] as $pregunta=>$respuesta)
                        @php
                            $cont++;
                        @endphp
                        <div class="col-md-12 mb-3 left">
                            <div>
                                <div class="siniestro-preguntas" style="text-align:left">{{ $cont }} - {{$questionsTrad[$pregunta]}}</div>
                                @php
                                    $respuesta_nice='';
                                    if ($respuesta=='-'){
                                        $respuesta_nice='-';
                                    }
                                    if ($respuesta=='true'){
                                        $respuesta_nice='SI';
                                    }
                                    if ($respuesta==false){
                                        $respuesta_nice='NO';
                                    }
                                @endphp
                                <div class="siniestro-respuestas" style="text-align:left">{{ $respuesta_nice }}</div>
                            </div>
                        </div>

                        @endforeach
                    </div>
            </div>

            <div class="card card-body border-0 shadow mb-4">
                <h2 class="h5 mb-4">Aseguradora</h2>
                    <div class="row">
                        <div class="col-md-6 mb-3"><label>Nombre</label>
                            <div class="seguro-data">
                                <img src="{{ $siniestro['insurance_risk']['company']['logo_filename'] }}" width="60px">
                                {{ $siniestro['insurance_risk']['company']['name'] }}</div>
                        </div>
                        <div class="col-md-6 mb-3">
                            <div>
                                <label for="last_name">Numero reclamo</label>
                                <div class="seguro-data">#{{ $siniestro['number_claim'] }}</div>
                            </div>
                        </div>
                        <div class="col-md-6 mb-3">
                            <div>
                                <label for="last_name">Responsable</label>
                                <div class="seguro-data">{{ $siniestro['responsible_assignee'] }}</div>
                            </div>
                        </div>
                        <div class="col-md-6 mb-3">
                            <div>
                                <label for="last_name">Pagos</label>
                                <div class="seguro-data"></div>
                            </div>
                        </div>
                    </div>
            </div>

            <div class="card card-body border-0 shadow mb-4">
                <h2 class="h5 mb-4">Anotaciones</h2>
                    <div class="row">
                        <textarea rows="10" wire:model="anotaciones">{{ $siniestro['observations'] }}</textarea>
                        <button wire:click="anotacionesSave">Actualizar</button>
                    </div>
            </div>

        </div>
    </div>
</div>
