<div>
<title>Mi perfil</title>
    <div class="row">
        <div class="col-12 col-xl-8">
            @if($showSavedAlert)
            <div class="alert alert-success" role="alert">
                {{$alertTxt}}
            </div>
            @endif
            @if($showErrorAlert)
            <div class="alert alert-warning" role="alert">
              {{$alertTxt}}
            </div>
            @endif
            <div class="card card-body border-0 shadow mb-4">
                <h2 class="h5 mb-4">General information</h2>
                <form wire:submit.prevent="save" action="#" method="POST">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <div>
                                <label for="first_name">Nombre</label>
                                <input class="form-control" id="first_name" type="text"
                                    placeholder="Ingresa tu nombre" wire:model="form.name" required>
                            </div>
                        </div>
                        <div class="col-md-6 mb-3">
                            <div>
                                <label for="last_name">Apellido</label>
                                <input value="{{session('usr_lastname')}}" class="form-control" id="form.last_name" type="text"
                                    placeholder="Ingresa Apellido">
                            </div>
                        </div>
                    </div>
                    <div class="row align-items-center">
                        <div class="col-md-6 mb-3">
                            <div class="form-group">
                                <label for="email">Email</label>
                                <input value="{{session('usr_email')}}" class="form-control" id="email" type="email"
                                    placeholder="Ingrese cuenta de correo" disabled>
                            </div>
                            @error('email') <div class="invalid-feedback">{{ $message }}</div> @enderror
                        </div>
                        <div class="col-md-6 mb-3">
                            <label for="gender">Genero</label>
                            <select class="form-select mb-0" id="gender"
                                aria-label="Gender select example">
                                <option selected>Elegir...</option>
                                <option value="Female">Femenino</option>
                                <option value="Male">Masculino</option>
                                <option value="Other">Otros</option>
                            </select>
                            @error('user.gender') <div class="invalid-feedback">{{ $message }}</div> @enderror
                        </div>
                    </div>
                    <h2 class="h5 my-4">Ubicacion</h2>
                    <div class="row">
                        <div class="col-sm-9 mb-3">
                            <div class="form-group">
                                <label for="address">Direccion</label>
                                <input wire:model="user.address" class="form-control" id="address" type="text"
                                    placeholder="Ingrese direccion">
                            </div>
                            @error('user.address') <div class="invalid-feedback">{{ $message }}</div> @enderror
                        </div>
                        <div class="col-sm-3 mb-3">
                            <div class="form-group">
                                <label for="number">MeCubro ID</label>
                                <input class="form-control" id="number" value="{{session('usr_id')}}" type="number"
                                    placeholder="No." disabled>
                            </div>
                            @error('user.number') <div class="invalid-feedback">{{ $message }}</div> @enderror
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-4 mb-3">
                            <div class="form-group">
                                <label for="city">Ciudad</label>
                                <input wire:model="user.city" class="form-control" id="city" type="text"
                                    placeholder="Ingrese ciudad">
                            </div>
                            @error('user.city') <div class="invalid-feedback">{{ $message }}</div> @enderror
                        </div>
                        <div class="col-sm-4">
                            <div class="form-group">
                                <label for="zip">ZIP</label>
                                <input wire:model="user.ZIP" class="form-control" id="zip" type="tel" placeholder="ZIP">
                            </div>
                        </div>
                        @error('user.ZIP') <div class="invalid-feedback">{{ $message }}</div> @enderror
                    </div>
                    <div class="mt-3">
                        <button type="submit" wire:click='save' class="btn btn-gray-800 mt-2 animate-up-2">Actualizar info</button>
                    </div>
                </form><br><br><br><br><br><br>
            MeCubro ID: {{ session('usr_id')}} ApiTk: {{session('usr_tk')}}
            </div>
        </div>
        <div class="col-12 col-xl-4">
            <div class="row">
                <div class="col-12 mb-4">
                    <div class="card shadow border-0 text-center p-0">
                        <div wire:ignore.self class="profile-cover rounded-top"
                            data-background="../assets/img/profile-cover.jpg"></div>
                        <div class="card-body pb-5">
                                <svg class="avatar-xl rounded-circle mx-auto mt-n7 mb-4" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                                    <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-6-3a2 2 0 11-4 0 2 2 0 014 0zm-2 4a5 5 0 00-4.546 2.916A5.986 5.986 0 0010 16a5.986 5.986 0 004.546-2.084A5 5 0 0010 11z" clip-rule="evenodd"></path>
                                  </svg>

                            <h4 class="h3">
                                {{  session('usr_name') }}
                            </h4>
                            <h5 class="fw-normal">MeCubro.com </h5>
                            <p class="text-gray mb-4">Mendoza, Argentina</p>
                            <a class="btn btn-sm btn-secondary" href="#">Send Message</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
