<div>
    <title>Billeteras</title>
    @if (session()->has('message-danger'))
        <div class="alert alert-danger">
            {{ session('message-danger') }}
        </div>
    @endif
    @livewire('components.page-filters', ['meta' => $meta, 'filters' => 'id|nombre|apellido|documento', 'filtroFecha' => 'no'])



    <div class="message-wrapper border-0 bg-white shadow rounded mb-1" style="clear:both">
        <div class="card-body d-flex align-items-center flex-wrap flex-lg-nowrap py-0">
            <div class="col-1 align-items-center px-0 d-none d-lg-flex center">#</div>
            <div class="col-4 col-lg-2 ps-0 ps-lg-3 pe-lg-3">Nombre</div>
            <div class="col-4 col-lg-2 ps-0 ps-lg-3 pe-lg-3">Documento</div>
            <div class="col-4 col-lg-2 ps-0 ps-lg-3 pe-lg-3">Moneda</div>
            <div class="col-1 col-lg-1 ps-0 ps-lg-3 pe-lg-3 center">Balance</div>
            <div class="col-4 col-lg-2 ps-0 ps-lg-3 pe-lg-3">Descubierto</div>
            <div class="col-4 col-lg-1 ps-0 ps-lg-3 pe-lg-3"></div>
            <div class="col-4 col-lg-1 ps-0 ps-lg-3 pe-lg-3 center">Opciones</div>
        </div>
    </div>

    <div wire:loading.block class="alert alert-info" role="alert">
        Actualizando Estado de la operacion...
    </div>
    @if (session()->has('message-success'))
        <div class="alert alert-success">
            {{ session('message-success') }}
        </div>
    @endif

    @if (!$operaciones || $operaciones == null)
        <div class="alert alert-success" role="alert">
            <i class="fa fa-superpowers" aria-hidden="true"></i>Sin resultados para la busqueda generada.
        </div>
    @else
        @foreach ($operaciones as $operacion)
            <?php
            $opClase = 'waiting';
            if ($operacion['balance'] >= 1) {
                $opClase = 'acreditted';
            }
            ?>
            <div class="message-wrapper border-0 bg-white shadow rounded mb-1">
                <div class="card hover-state border-bottom rounded-0 rounded-top py-1">
                    <div class="card-body d-flex align-items-center flex-wrap flex-lg-nowrap py-0">
                        <div class="col-1 align-items-center px-0 d-none d-lg-flex">
                            {{ $operacion['id'] }}
                        </div>


                        <div class="col-4 col-lg-2 ps-0 ps-lg-3 pe-lg-3">
                            <img src="{{ $operacion['entity']['avatar'] ?? '' }}" class="avatar-sm rounded-circle me-3"
                                alt="{{ $operacion['id'] }}">
                            {{ $operacion['entity']['first_name'] }}
                        </div>

                        <div class="col-3 col-lg-2 ps-0 ps-lg-2 pe-lg-2 center">{{ $operacion['entity']['document_nice']}}</div>
                        <div class="col-3 col-lg-2 ps-0 ps-lg-2 pe-lg-2 center">{{ $operacion['currency']['short_code']}}</div>



                        <div class="col-4 col-lg-1 ps-0 ps-lg-3 pe-lg-3 lchica center">
                            <span class="operation-status {{ $opClase }}" style="padding:5px 10px; width:60px">{{ $operacion['balance_nice'] }}</span>
                        </div>

                        <div class="col-4 col-lg-2 ps-0 ps-lg-3 pe-lg-3 lchica center">
                           {{ $operacion['overdraft_limit_nice'] }}
                        </div>

                        <div class="col-3 col-lg-1 ps-0 ps-lg-2 pe-lg-2 center">
                            <a class='btn btn-gray-100'
                            wire:click="showMovements({{ $operacion['id'] }}, '{{ $operacion['entity']['first_name'] }}')" >Movimientos</a>
                        </div>

                        <div class="col-2 col-lg-1 d-flex align-items-center justify-content-end px-0 order-lg-4">
                            <div class="dropdown ms-3">
                                <button type="button" class="btn btn-sm fs-6 px-1 py-0 dropdown-toggle"
                                    id="dropdownMenuLink" data-bs-toggle="dropdown" aria-expanded="false">
                                    <svg class="icon icon-xs" fill="currentColor" viewBox="0 0 20 20"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M6 10a2 2 0 11-4 0 2 2 0 014 0zM12 10a2 2 0 11-4 0 2 2 0 014 0zM16 12a2 2 0 100-4 2 2 0 000 4z">
                                        </path>
                                    </svg>
                                </button>
                                <div class="dropdown-menu dashboard-dropdown dropdown-menu-start mt-2 py-1">
                                    <a class="dropdown-item d-flex align-items-center" wire:click="$emit('cargar-billetera',{{ $operacion['id'] }})" >
                                        <svg class="dropdown-icon text-gray-400 me-2" fill="currentColor"
                                            viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M4 3a2 2 0 100 4h12a2 2 0 100-4H4z"></path>
                                            <path fill-rule="evenodd"
                                                d="M3 8h14v7a2 2 0 01-2 2H5a2 2 0 01-2-2V8zm5 3a1 1 0 011-1h2a1 1 0 110 2H9a1 1 0 01-1-1z"
                                                clip-rule="evenodd"></path>
                                        </svg> Cargar con transferencia
                                    </a>
                                    <a class="dropdown-item d-flex align-items-center" wire:click="showMovements({{ $operacion['id'] }}, '{{ $operacion['entity']['first_name'] }}')"
                                   >
                                        <svg class="dropdown-icon text-gray-400 me-2" fill="currentColor"
                                            viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                                            <path fill-rule="evenodd"
                                                d="M10 18a8 8 0 100-16 8 8 0 000 16zm1-12a1 1 0 10-2 0v4a1 1 0 00.293.707l2.828 2.829a1 1 0 101.415-1.415L11 9.586V6z"
                                                clip-rule="evenodd"></path>
                                        </svg> Movimientos
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        @endforeach
    @endif



    @livewire('components.wallet-movements')
    @livewire('components.crear-transferencia-bancaria')




</div>
