<div>
    <title>Transferencias Bancarias</title>
    @if (session()->has('message-danger'))
        <div class="alert alert-danger">
            {{ session('message-danger') }}
        </div>
    @endif
    @livewire('components.page-filters', ['meta' => $meta, 'filters' => 'id|bank|billetera|name|depositado'])
    <div wire:loading.block class="alert alert-info" role="alert">
        Actualizando Estado de la operacion... <img src="/assets/img/loading.gif" width="35px">
    </div>
    <div class="message-wrapper border-0 bg-white shadow rounded mb-1" style="clear:both">
        <div class="card-body d-flex align-items-center flex-wrap flex-lg-nowrap py-0">
            <div class="col-1 align-items-center px-0 d-none d-lg-flex center">#</div>
            <div class="col-1 col-lg-1 ps-0 ps-lg-3 pe-lg-3 center">Monto</div>
            <div class="col-4 col-lg-1 ps-0 ps-lg-3 pe-lg-3 center">Banco</div>
            <div class="col-4 col-lg-4 ps-0 ps-lg-3 pe-lg-3 center">Usuario</div>

            <div class="col-4 col-lg-3 ps-0 ps-lg-3 pe-lg-3 center">Historial</div>
            <div class="col-4 col-lg-1"></div>
            <div class="col-4 col-lg-1 ps-0 ps-lg-3 pe-lg-3 center"></div>
        </div>
    </div>
    @if (session()->has('message-success'))
        <div class="alert alert-success">
            {{ session('message-success') }}
        </div>
    @endif
    @if ($operaciones)
        @foreach ($operaciones as $operacion)
            <?php
            $opClase = 'waiting';
            if ($operacion['accredited']) {
                $opClase = 'acreditted';
            }
            if ($operacion['rejected']) {
                $opClase = 'rejected';
            }

            ?>
            <div class="message-wrapper border-0 bg-white shadow rounded mb-1">
                <div class="card hover-state border-bottom rounded-0 rounded-top my-2">
                    <div class="card-body d-flex align-items-center flex-wrap flex-lg-nowrap py-0">
                        <div class="col-1 align-items-center px-0 d-none d-lg-flex">
                            {{ $operacion['id'] }}
                        </div>
                        <div class="col-4 col-lg-1 ps-0 ps-lg-2 pe-lg-3">
                            <strong>${{ $operacion['amount'] }} </strong>
                        </div>
                        <div class="col-4 col-lg-2 ps-0 ps-lg-2 pe-lg-3 lchica">
                            <span class="bank-desde">
                                Cuenta Origen: {{ $operacion['from_account']}}<br>
                            </span>
                            {{ $operacion['bank_account']['bank'] . ' ' . $operacion['bank_account']['name'] }}<br>Cuenta:
                            {{ $operacion['bank_account']['number'] }}
                        </div>

                        <div class="col-4 col-lg-3 ps-0 ps-lg-3 pe-lg-3">
                            <img src="{{ $operacion['wallet']['entity']['avatar'] }}"
                                class="avatar-sm rounded-circle me-3" alt="{{ $operacion['id'] }}">
                            {{ $operacion['wallet']['entity']['name_nice'] }}
                        </div>
                        <div class="col-4 col-lg-3 ps-0 ps-lg-3 pe-lg-3 lchica operation-status {{ $opClase }}">
                            Depositado: <span>{{ $this->getFecha($operacion['deposited']) }}</span><br>
                            @if ($operacion['approved'])
                                Aprobado: <span>{{ $this->getFecha($operacion['approved']) }}</span><br>
                            @endif
                            @if ($operacion['rejected'])
                                Rechazado: <span>{{ $this->getFecha($operacion['rejected']) }}</span><br>
                            @endif
                            @if ($operacion['accredited'])
                                Acreditado: <span>{{ $this->getFecha($operacion['accredited']) }}</span><br>
                            @endif
                        </div>


                        <div class="col-2 col-lg-2 d-flex align-items-center justify-content-end px-0 order-lg-4">
                            <div class="dropdown ms-3">
                                <button type="button" class="btn btn-sm fs-6 px-1 py-0 dropdown-toggle"
                                    id="dropdownMenuLink" data-bs-toggle="dropdown" aria-expanded="false">
                                    <svg class="icon icon-xs" fill="currentColor" viewBox="0 0 20 20"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M6 10a2 2 0 11-4 0 2 2 0 014 0zM12 10a2 2 0 11-4 0 2 2 0 014 0zM16 12a2 2 0 100-4 2 2 0 000 4z">
                                        </path>
                                    </svg>
                                </button>
                                <div class="dropdown-menu dashboard-dropdown dropdown-menu-start mt-2 py-1">
                                    <a class="dropdown-item d-flex align-items-center"
                                        wire:click="changeStatus({{ $operacion['id'] }}, 'accredit')" wire:loading>
                                        <svg class="dropdown-icon text-gray-400 me-2" fill="currentColor"
                                            viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M4 3a2 2 0 100 4h12a2 2 0 100-4H4z"></path>
                                            <path fill-rule="evenodd"
                                                d="M3 8h14v7a2 2 0 01-2 2H5a2 2 0 01-2-2V8zm5 3a1 1 0 011-1h2a1 1 0 110 2H9a1 1 0 01-1-1z"
                                                clip-rule="evenodd"></path>
                                        </svg> Acreditar
                                    </a>
                                    <a class="dropdown-item d-flex align-items-center"
                                        wire:click="changeStatus({{ $operacion['id'] }}, 'reject')"><svg
                                            class="dropdown-icon text-gray-400 me-2" fill="currentColor"
                                            viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                                            <path fill-rule="evenodd"
                                                d="M2.94 6.412A2 2 0 002 8.108V16a2 2 0 002 2h12a2 2 0 002-2V8.108a2 2 0 00-.94-1.696l-6-3.75a2 2 0 00-2.12 0l-6 3.75zm2.615 2.423a1 1 0 10-1.11 1.664l5 3.333a1 1 0 001.11 0l5-3.333a1 1 0 00-1.11-1.664L10 11.798 5.555 8.835z"
                                                clip-rule="evenodd"></path>
                                        </svg> Rechazar
                                    </a>
                                    @if (2==3)
                                    <a class="dropdown-item d-flex align-items-center"
                                        wire:click="changeStatus({{ $operacion['id'] }}, 'approve')">
                                        <svg class="dropdown-icon text-gray-400 me-2" fill="currentColor"
                                            viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                                            <path fill-rule="evenodd"
                                                d="M10 18a8 8 0 100-16 8 8 0 000 16zm1-12a1 1 0 10-2 0v4a1 1 0 00.293.707l2.828 2.829a1 1 0 101.415-1.415L11 9.586V6z"
                                                clip-rule="evenodd"></path>
                                        </svg> Aprobar
                                    </a>
                                    <a class="dropdown-item d-flex align-items-center"
                                        href="/usuarios/{{ $operacion['wallet']['entity']['id'] }}">
                                        <svg class="icon icon-xs me-2" fill="currentColor" viewBox="0 0 20 20"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M9 6a3 3 0 11-6 0 3 3 0 016 0zM17 6a3 3 0 11-6 0 3 3 0 016 0zM12.93 17c.046-.327.07-.66.07-1a6.97 6.97 0 00-1.5-4.33A5 5 0 0119 16v1h-6.07zM6 11a5 5 0 015 5v1H1v-1a5 5 0 015-5z">
                                            </path>
                                        </svg> Ficha Cliente
                                    </a>
                                    @endif

                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        @endforeach
    @else
        <div class="alert alert-success" role="alert">
            <i class="fa fa-superpowers" aria-hidden="true"></i>Sin resultados para la busqueda generada.
        </div>
    @endif







</div>
