
<div>
    <title>Criptobots home Admin</title>

    <table id="dataTable" class="display">
        <thead>
            <tr>
                <th>ID</th>
                <th>Simbos</th>
                <th>Online</th>
                <th>Operando</th>
                <th>Ordenes</th>
                <!-- Otros campos -->
            </tr>
        </thead>
        <tbody>
            <!-- Los datos serán generados aquí con un foreach() -->
        </tbody>
    </table>
    <script>
        $(document).ready(function () {
            const data = @json($data); // Convertir el array PHP a un objeto JavaScript
            const table = $('#dataTable').DataTable({
                data: data, // Asignar los datos al DataTable
		        'pageLength': 10,
		        language: { search: '' },
		        'bLengthChange' : false,
                'aaSorting': [],
                columns: [
                    { data: 'id' },      // Corresponde a la clave 'id' en el array de datos
                    { data: 'simbolos' },  // Corresponde a la clave 'nombre' en el array de datos
                    { data: 'online' },   // Corresponde a la clave 'email' en el array de datos
                    { data: 'operando' },
                    { data: 'ordenes' },
                    // Otras columnas
                ]
            });
        });
    </script>




<style>
  
    .tr-head{
        background-color: #484848;
        overflow: hidden;	
        color: #fff;
        text-transform: uppercase;
    }
    table.dataTable.stripe tbody tr.odd, table.dataTable.display tbody tr.odd {
        background-color: #ffffff;
    }
    table.dataTable.stripe tbody tr.odd, table.dataTable.display tbody tr.odd:hover {
        background-color: #ffbf86;
    }
    
    table.dataTable.stripe tbody tr.odd, table.dataTable.display tbody tr.even:hover {
        background-color:#ffbf86;
    }
    
    input {
        padding: 2px!important;
        font-size: 14px!important;
        height: 28px!important;
         width:auto!important;
    }
        .online-activo{
            color:#fff;
            background:#00a707;
            font-weight:bold;	
            padding: 4px 15px;
        }
        .online-no-activo{
            color: #fff;
            background: #f00;
            font-weight: bold;
            padding: 4px 15px;
        }
        .header{
            background-color: #484848;		
            overflow:hidden;
        }
        .header div{
            color: #fff;
            text-transform: uppercase;	
        }
        .col0,.col1,.col2,.col3,.col4, .col5, .col6, .col7{
            float:left;
            width:20%;
            padding: 5px 5px;		
        }
        .col0{
            width:6%;	
        }
        .col1{
            width:20%;			
        }
        .col2{
            width:8%;	
        }	
        .col3{
            width:8%;	
        }	
        .col4{
            width:10%;	
        }	
        .col5, .col6, .col7{
            width:15%;	
        }
        thead, tbody, tfoot, tr, td, th {
            font-family: Arial, sans-serif; /* Ejemplo de cambio de fuente */
            font-size: 14px; /* Ejemplo de cambio de tamaño de fuente */
            font-weight: normal!important;
            /* Otros estilos que desees aplicar a las filas */
        }
        table.dataTable.stripe tbody tr{
            clear:both;	
            font-size: 14px;
            font-weight: normal;
        }
        .bal-fila{
            clear:both;
            margin:3px;	
            padding-bottom: 25px!important;
        }
        .bal-fila div{
            float:left;
            text-align:left;
        }
        .bal-mon{
            width:25%;	
        }
        .bal-cant{
            width:45%;	
        }
        .bal-saldo{
            width:30%;	
        }
        .bal-impo{
            background: beige;	
        }
        .onorden{
            background:#ffcca7;	
        }
      </style>






</div>
