<div wire:init="buscarOps">
    <title>Emulador {{$arrCoin['simbolo']}}-USDT</title>
    <div class="row pt-2">
        <div class="col-1">
            <div>Emular {{ $arrCoin['simbolo'] ?? '' }} -USDT</div>
            <div>Status: Nuevo</div>
        </div>
        <div class="col-1">
            <div>
                <button class="btn btn-success" wire:click="start">
                    <span wire:loading.remove wire:target="start">Start</span>
                    <span wire:loading wire:target="start">Iniciando...</span>
                </button>
                
                <button class="btn btn-danger" wire:click="stop">
                    <span wire:loading.remove wire:target="start">Stop</span>
                    <span wire:loading wire:target="start">Finalizando...</span>                    
                </button>
            </div>
        </div>
        <div class="col-1">
            <select id="sel_modo" name="sel_modo" class="form-select">
                <option value="0">Rapido</option>
                <option value="1">Sensible</option>
            </select>
        </div>
        <div class="col-2"><select id="sel_filled" name="sel_filled" class="form-select">
                <option value="0">La cotiz debe pasar el valor de compra/venta</option>
                <option value="1">Filled Automatico</option>
            </select></div>
        <div class="col-1"><select id="sel_tipo" name="sel_tipo" class="form-select" wire:model="configTipo"  wire:change="buscarOps">
                <option value="0">Ninguna</option>
                <option value="1">Real</option>
                <option value="2">Simulacion</option>
                <option value="3">Emulacion</option>
            </select></div>
        <div class="col-1"><select id="sel_estado" name="sel_estado" class="form-select">
                <option value="0">compra y venta</option>
                <option value="1">Solo Abiertas</option>
                <option value="2">Solo Compras</option>
                <option value="3">Solo Ventas</option>
            </select></div>
        <div class="col-1">Estrategias in/out</div>
        <div class="col-1"><input type="date" name="fecha_desde" id="fecha_desde" wire:model.defer="fecha_desde"
                min="{{ $fecha_min }}" max="{{ $fecha_max }}" class="form-control"></div>
        <div class="col-1"><input type="date" name="fecha_hasta" id="fecha_hasta" wire:model.defer="fecha_hasta"
                min="{{ $fecha_min }}" class="form-control"></div>
        <div class="col-1"><button type="button" class="btn btn-success" wire:click="cambiarFechas"
                >
                <span wire:loading.remove wire:target="cambiarFechas">Actualizar</span>
                <span wire:loading wire:target="cambiarFechas">Cargando...</span>
            </button>
            <a href="https://bot.criptobots.com/automatico/emuladorData.php" target="new">Actualizar velas</a>
        </div>
    </div>

{{$keyGrafico}}
    @livewire('emulador.grafico', ['id_moneda' => $this->id_moneda], key($keyGrafico))

    <div> {{$output}} </div>

    <div class="row mt-3 center">
        <div class="col-4">
            <div class="row">
                <div class="col-6">Estado</div>
                <div class="col-6">{{ $sisData['status'] ?? 'n/a' }}</div>
            </div>
            <div class="row">
                <div class="col-6">Tiempo de ejecucion</div>
                <div class="col-6">{{ $sisData['tiempo'] ?? 'n/a' }}</div>
            </div>
            <div class="row">
                <div class="col-6">Cant velas</div>
                <div class="col-6">{{ $sisData['velas_actual'] ?? 'n/a' }}/{{ $sisData['velas_total'] ?? 'n/a' }} - {{ $sisData['velas_actual_fecha'] ?? 'n/a' }}</div>
            </div>
            <div class="row">
                <div class="col-6">Ordenes abiertas</div>
                <div class="col-6">{{ $sisData['ordenes_abiertas'] ?? 'n/a' }}</div>
            </div>
        </div>
<div class="col-4">
        1
        </div>
        <div class="col-4">
            <div><button class="btn btn-danger" onclick="confirm('Eliminar Emulaciones?') || event.stopImmediatePropagation()"  wire:click="eliminarEmulaciones">Eliminar Emulaciones</button></div>
            <div><button class="btn btn-danger mt-2" onclick="confirm('Eliminar Simulaciones?') || event.stopImmediatePropagation()"  wire:click="eliminarSimulaciones">Eliminar Simulaciones</button></div>
        </div>
    </div>
    

        <div wire:poll.5s="buscarOps"></div>
</div>
