<?php

namespace App\Http\Livewire\Siniestros;
use App\Http\Livewire\BaseComponent;
use App\Services\MecubroService;

class Siniestros extends BaseComponent
{
    protected $listeners = ['page-update' => 'pageUpdate'];
    public $siniestros;
    public $siniestros_estados;

    public $siniestro_activo_id;
    public $siniestro_activo_estado;
    public $btn_blocked = 0;

    public function mount(MecubroService $mecubroService)
    {
        $this->refresh();
        $conditions['filter']['type']['eq'] = 'claims';
        $result = $mecubroService->siniestroEstados($conditions);
        $this->siniestros_estados = $result['data'];
    }

    public function refresh()
    {
        $mecubroService=new MecubroService;
        $result = $mecubroService->siniestros(
            [
                'filter[date][ge]' => $this->fecha1,
                'filter[date][le]' => $this->fecha2 ,
                'filter[id][like]' => $this->search,
                'sort_by' => '-id', 'page' => $this->mostrarPagina,
                'limit' => 14
             ]);
             //dd($result['data']);
        $this->siniestros = $result['data'];
        $this->meta = $result['meta'];
    }

    public function render()
    {
        $this->pageEnable();
        return view('livewire.siniestros.siniestros');
    }

    public function changeStatus($siniestro_id, $siniestro_estado)
    {
        $this->modal_open = true;
        $this->btn_blocked = 0;
        $this->siniestro_activo_id = $siniestro_id;
        $this->siniestro_activo_estado = $siniestro_estado;
    }
    public function changeStatusSave(MecubroService $mecubroService, $newStatus)
    {
        $this->btn_blocked = 1;
        $result = $mecubroService->siniestroEstadosUpdate($this->siniestro_activo_id, ['status_id' => $newStatus]);
        $this->cerrarModal();
        $this->refresh($mecubroService);
    }


}
