<?php

namespace App\Http\Livewire;

use App\Models\InverEstrategia;
use Livewire\Component;
use Illuminate\Support\Facades\Redis;
use App\Models\InverOrden;

class LivOrdenes extends Component
{
    public $id_moneda;
    public $arrOrdenes;
    public $txtActualizado;
    public $estrategiasData;

    public function mount(){
        $this->cargarOrdenes(); 
    }
    
    public function render()
    {
        return view('livewire.liv-ordenes');
    }

    public function cargarOrdenes(){
        $tiempo_actual = time();
        $this->txtActualizado='';
        $this->arrOrdenes = json_decode(Redis::get($this->id_moneda . '_ordenes'), true); 
        $this->estrategiasData = InverEstrategia::all();
       
        if ($this->arrOrdenes !== null) {
            $fecha_almacenada_timestamp = $this->arrOrdenes['timestamp'] ?? null;
            $diferencia_segundos = $tiempo_actual - $fecha_almacenada_timestamp;
            if ($diferencia_segundos <= 180) {

            } else {
                $this->txtActualizado='Desactualizado!!!!!';
 
            }
        } else {
            
        }     
       // $this->arrOrdenes= new Collection($this->arrOrdenes);      
    }   

    public function cancelarOrden($id){
        $orden = InverOrden::find($id);
        if ($orden) {
            $orden->estado = 0;
            $orden->save();
            $this->emit('mostrarMensaje', 'Orden cancelada a estado 0.');
        } else {
            $this->emit('mostrarMensaje', 'Error al cancelar la orden.');
        }
    }
    public function venderOrden($id){
        $orden = InverOrden::find($id);
        if ($orden) {
            $orden->estado = 12;
            $orden->save();
            $this->emit('mostrarMensaje', 'Iniciando venta.');
        } else {
            $this->emit('mostrarMensaje', 'Error al iniciar venta.');
        }
    }
}
