<?php

namespace App\Http\Livewire;

use Livewire\Component;
use App\Models\InverLog;
use App\Models\InverLogsTipo;
 
class LivLog extends Component
{
    public $id_moneda;
    public $arrLogs;
    public $arrLogsTipos;

    public function mount(){
        $this->arrLogsTipos = InverLogsTipo::all()->keyBy('id_log_tipo')->toArray();
        $this->cargarLogs();
    }

    public function render()
    {
        return view('livewire.liv-log');
    }

    public function cargarLogs(){
        $this->arrLogs = InverLog::where('id_moneda', $this->id_moneda)
        ->latest() // Ordenar por fecha de forma descendente
        ->take(50) // Obtener los últimos 50 registros
        ->get()
        ->toArray();       
    }

    public function tiempoTranscurrido($createdAt)
    {
        $now = time();
        $createdTime = strtotime($createdAt);
    
        $diferencia = $now - $createdTime;
    
        if ($diferencia < 60) {
            return "$diferencia segundos atrás";
        } elseif ($diferencia < 3600) {
            $minutos = floor($diferencia / 60);
            return "hace $minutos minutos";
        } elseif ($diferencia < 86400) {
            $horas = floor($diferencia / 3600);
            $minutosRestantes = floor(($diferencia - ($horas * 3600)) / 60);
            return "hace $horas h $minutosRestantes m";
        } elseif ($diferencia < 2592000) {
            $dias = floor($diferencia / 86400);
            return "$dias días atrás";
        } else {
            return date('d-m-Y', $createdTime);
        }
    }
    
    
}
