<?php

namespace App\Http\Livewire\Emulador;

use phpseclib3\Net\SSH2;

use App\Http\Livewire\BaseComponent;
use Illuminate\Support\Facades\Redis;
use App\Models\InverCartera;
use App\Models\InverCarteraEstrategia;
use App\Models\InverEstrategia;
use App\Models\InverEmulador;
use App\Models\InverVelas1m10d;
use Illuminate\Support\Collection;
use App\Models\InverOrden;
use DateTime;
use Carbon\Carbon;
use Illuminate\Support\Facades\Config;

class Emulador extends BaseComponent
{
    public $id_moneda;
    public $Coin;
    public $arrCoin;
    public $coinTitulo;

    public $formato_x = '';
    public $decimales_cot = '';


    public $fecha_min;
    public $fecha_max;
    public $fecha_desde;
    public $fecha_hasta;
    public $dataPoints_m_10d = '';
    public $arr_ops_10d = [];

    public $redisData;
    public $keyGrafico = 0;

    public $configTipo = 3;
    public $arrOrdenes;
    public $grafOrdenes;

    public $arr_estrategias_colores=[];
    public $sisData;
    public $output;
    public function mount($id)
    {
        $this->id_moneda = $id;
        $this->arrCoin['simbolo'] = 'cargando...';


        $rs_estrategias = InverEstrategia::all();
        foreach ($rs_estrategias as $estrategia) {
            $this->arr_estrategias_colores[$estrategia->id_estrategia] = $estrategia->color;
        }

        $this->fecha_min = date('Y-m-d', strtotime('-10 days'));
        $this->fecha_max = date('Y-m-d');

        $this->fecha_desde = Redis::get('fecha_desde') ?? $this->fecha_min;
        $this->fecha_hasta = Redis::get('fecha_hasta') ?? $this->fecha_max;

        $this->Coin = InverCartera::where('id_mon', $this->id_moneda)->first();
        $this->coinTitulo = $this->Coin->simbolo;
        $this->arrCoin = $this->Coin->toArray();

        $emulador = InverEmulador::firstOrNew(['id_moneda' => $this->id_moneda]);
        $emulador->save();  
        
    }



    public function cambiarFechas()
    {
       
        $rs_velas1m = InverVelas1m10d::selectRaw("*, DATE_FORMAT(fecha_vela, '%Y,%m,%e') AS fecha_stats, DATE_FORMAT(fecha_vela, '%H,%i') AS hora_stats")
            ->where('id_moneda', $this->id_moneda)
            ->whereDate('fecha_vela', '>=', $this->fecha_desde)
            ->whereDate('fecha_vela', '<=', $this->fecha_hasta)
            ->orderBy('fechaHora', 'ASC')
            ->get();

        Redis::set('rs_velas1m', gzcompress(json_encode($rs_velas1m)));
        Redis::set('fecha_desde', $this->fecha_desde);
        Redis::set('fecha_hasta', $this->fecha_hasta);      
        $dataPoints = $this->formatDataPoints();
        $this->emit('datosActualizados', $dataPoints);
        $this->buscarOps();
    }


    public function start()
    {
        $remoteHost = 'criptobots.com'; // Config::get('env.REMOTE_HOST');
        $remotePort = 22; // Config::get('env.REMOTE_PORT');
        $remoteUsername = 'bot'; //Config::get('env.REMOTE_USERNAME');
        $remotePassword = 'matias07R2'; //Config::get('env.REMOTE_PASSWORD');

        $ssh = new SSH2($remoteHost, $remotePort);


        if (!$ssh->login($remoteUsername, $remotePassword)) {
            return 'Error de autenticación SSH';
        }

        $command = 'cd /home/bot/public_html/automatico/ && php -n -q emuladorRun.php > /dev/null &';
        $this->output = $ssh->exec($command);

        $ssh->disconnect();

    }

    
    public function stop()
    {
        $remoteHost = 'criptobots.com'; // Config::get('env.REMOTE_HOST');
        $remotePort = 22; // Config::get('env.REMOTE_PORT');
        $remoteUsername = 'bot'; //Config::get('env.REMOTE_USERNAME');
        $remotePassword = 'matias07R2'; //Config::get('env.REMOTE_PASSWORD');
        $cadenaBusqueda = 'emuladorRun.php';

        // Crea una instancia de SSH2
        $ssh = new SSH2($remoteHost, $remotePort);
        if (!$ssh->login($remoteUsername, $remotePassword)) {
            return 'Error de autenticación SSH';
        }

        $command = "pgrep -f '$cadenaBusqueda' | grep -v 'pgrep'";
        $pidList = $ssh->exec($command);

        // Divide la lista de PIDs en un array
        $pidArray = explode("\n", trim($pidList));

        // Inicializa una variable para almacenar los resultados
        $results = [];
        // Recorre la lista de PIDs y detiene cada proceso
        foreach ($pidArray as $pid) {
            if (!empty($pid) && is_numeric($pid)) {
                // Detiene el proceso utilizando el PID
                $command = "kill $pid";
                $output = $ssh->exec($command);

                // Almacena el resultado en el array de resultados
                $results[] = "Proceso $pid detenido: $output";
            }
        }

        $ssh->disconnect();

        if (!empty($results)) {
            $this->emit('mostrarMensaje', 'Emulacion detenida.');
        } else {
            $this->emit('mostrarMensaje', 'Error al denter Emulacion.');
        }       


    }    

    public function eliminarEmulaciones(){
        InverOrden::where('emulacion', 1)
            ->where('simbolo_id', $this->id_moneda)
            ->delete();
        $this->emit('mostrarMensaje', 'Emulaciones eliminadas.');       
        $this->buscarOps();
    }

    public function eliminarSimulaciones()
    {
        InverOrden::where('simulacion', 1)
            ->where('emulacion', 0)
            ->where('simbolo_id', $this->id_moneda)
            ->delete();

        $this->emit('mostrarMensaje', 'Simulaciones eliminadas.');
        $this->buscarOps();
    }

    private function formatDataPoints()
    {
        $dataPoints_m_10d = '';
        $redisDatos = json_decode(gzuncompress(Redis::get('rs_velas1m')));

        $cont = 0;
        $dataPoints_m_10d .= '[';
        foreach ($redisDatos as $vela) {
            if ($vela->fecha_stats != '') {
                list($year, $month, $day, $hour, $minute) = explode(',', $vela->fecha_stats . ',' . $vela->hora_stats);

                // Elimina espacios en blanco si los hay
                $year = ltrim($year, '0');
                $month = ltrim($month, '0');
                $day = ltrim($day, '0');
                $hour = ($hour === '00') ? '0' : ltrim($hour, '0');
                $minute = ($minute === '00') ? '0' : ltrim($minute, '0');

                $dataPoints_m_10d .= '{x: new Date(' . $year . ',' . ($month - 1) . ',' . $day . ',' . $hour . ',' . $minute . '),y:[' . $vela->open . ', ' . $vela->high . ', ' . $vela->low . ', ' . $vela->close . '],label2:"' . $vela->fecha_stats . ',' . $vela->hora_stats . '"},';
            }


            $cont = $cont + 1;
            if ($cont == 3) {
                //     break;
            }
        }

        $dataPoints_m_10d = substr($dataPoints_m_10d, 0, -1);
        $dataPoints_m_10d .= ']';

        return $dataPoints_m_10d;
    }



    public function render()
    {
        return view('livewire.emulador.emulador');
    }



    public function buscarOps()
    {
        // Realiza la búsqueda y el filtrado aquí en función de los valores seleccionados
        $query = InverOrden::CustomStats();
        $query->where('simbolo_id', $this->id_moneda);
        switch ($this->configTipo) {
            case 1:
                $query->where('simulacion', 0);
                break;
            case 2:
                $query->where('simulacion', 1);
                break;
            case 3:
                $query->where('emulacion', 1);
                break;
            default:
                // Manejo de caso por defecto
                break;
        }

        // Filtra por estado si lo necesitas
        // if ($this->mostrarEstado !== null) {
        //     $query->where('estado', $this->mostrarEstado);
        // }
       
        // Filtra por rango de fechas si están definidas
        $fechaHasta = Carbon::parse($this->fecha_hasta)->endOfDay();

        $query->whereBetween('fecha_creacion', [$this->fecha_desde, $fechaHasta]);
        $this->arrOrdenes = $query->get();
       // dd( $this->arrOrdenes );
     //  print_r($this->arrOrdenes);
        $this->grafOrdenes = $this->obtenerOperaciones($this->arrOrdenes);

        $this->emit('operacionesActualizadas', json_encode($this->grafOrdenes));
        $this->sisData = json_decode(Redis::get('emulador'), true);
   // $this->emit('operacionesActualizadas', '[{ x: new Date(2023,07,31,21,00), y: "214.3", indexLabel:"134734", markerType: "triangle", markerColor: "#0f0", lineColor: "#fff" }]');
    
    }






    function obtenerOperaciones($rs_operaciones)
    {
        $dataPoints_m_10d = [];
        $dataPoints_m_10d2=[];
        $mostrar_estado=2;
        $cont_alturas=0;
        foreach ($rs_operaciones as $op) {   
            list($year, $month, $day, $hour, $minute) = explode(',', $op->fecha_stats . ',' . $op->hora_stats);
            $year = ltrim($year, '0');
            $month = ltrim($month, '0');
            $day = ltrim($day, '0');
         //   $hour = ($hour === '00') ? '0' : ltrim($hour, '0');
          //  $minute = ($minute === '00') ? '0' : ltrim($minute, '0');

            $minimo = $op->comprar_precio;
            $fecha_compra = 'new Date(' . $year . ',' . ($month - 1) . ',' . $day . ',' . $hour . ',' . $minute . ')';
            $color_linea = '#fff';

            $color_circulo = '6B8E23';
            
            switch ($op->estado){
                case 1:
                    $color_triangulo = '#000';
                    $dataPoints_m_10d[] = '{ x: ' . $fecha_compra . ', y: ' . $minimo . ', indexLabel:"' . $op->estado . '-' . $op->id_orden . '", markerType: "triangle", markerColor: "' . $color_triangulo . '", lineColor: "' . $color_linea . '" }';
                    break;
                case 2:
                    $color_triangulo = '#' . $this->arr_estrategias_colores[$op->estrategia_base] ;
                    $dataPoints_m_10d[] = '{ x: ' . $fecha_compra . ', y: ' . $minimo . ', indexLabel:"' . $op->estado . '-' . $op->id_orden . '", markerType: "triangle", markerColor: "' . $color_triangulo . '", lineColor: "' . $color_linea . '" }';
                case 3:
                    $color_triangulo = '#000';
                    $dataPoints_m_10d[] = '{ x: ' . $fecha_compra . ', y: ' . $minimo . ', indexLabel:"' . $op->estado . '-' . $op->id_orden . '", markerType: "triangle", markerColor: "' . $color_triangulo . '", lineColor: "' . $color_linea . '" }';
                    break;
                case 4:
                    $color_linea = ($op->comprar_precio < $op->vender_precio) ? '#0f0' : '#f00';
                    $color_triangulo = '#' . $this->arr_estrategias_colores[$op->estrategia_base];
                    $txt_compra = '{ x: ' . $fecha_compra . ', y: ' . $minimo . ', indexLabel:"' . $op->estado . '-' . $op->id_orden . '", markerType: "triangle", markerColor: "' . $color_triangulo . '", lineColor: "' . $color_linea . '" }';
    
                    list($year, $month, $day, $hour, $minute) = explode(',', $op->fecha_stats_venta . ',' . $op->hora_stats_venta);
                    $year = ltrim($year, '0');
                    $month = ltrim($month, '0');
                    $day = ltrim($day, '0');
                    $hour = ($hour === '00') ? '0' : ltrim($hour, '0');
                    $minute = ($minute === '00') ? '0' : ltrim($minute, '0');
                    $fecha_venta = 'new Date(' . $year . ',' . ($month - 1) . ',' . $day . ',' . $hour . ',' . $minute . ')';

                    $color_linea = ($op->comprar_precio < $op->vender_precio) ? '#0f0' : '#f00';
                    $color_circulo = ($op->estado == 4) ? '#' . $color_circulo : '#fff';

                    $minimo2 = $op->vender_precio;
                    $dataPoints_m_10d[] = $txt_compra . ',{ x: ' . $fecha_venta . ', y: ' . $minimo2 . ', indexLabel:"' . $op->estado . '-' . $op->id_orden . '", markerType: "circle", markerColor: "' . $color_circulo . '", lineColor: "' . $color_linea . '" }';
                    break;
                case 0:
                    $color_triangulo = ($op->estado == 4) ? '#' . $color_triangulo : '#c0c0c0';
                    $dataPoints_m_10d[] = '{ x: ' . $fecha_compra . ', y: ' . $minimo . ', indexLabel:"' . $op->estado . '-' . $op->id_orden . '", markerType: "triangle", markerColor: "' . $color_triangulo . '", lineColor: "' . $color_linea . '" }';
                    break;                                                                                
            }


            $cont_alturas = $cont_alturas + 1;
            if ($cont_alturas == 5) {
                $cont_alturas = 0;
            }
        }

        return $dataPoints_m_10d;
        // Convierte el array en una cadena concatenada
      //  $dataPoints_m_10d_concatenado = '[' . implode(',', $dataPoints_m_10d) . ']';
    }
}