<?php

namespace App\Http\Livewire;
use App\Http\Livewire\BaseComponent;
use App\Models\InverCartera;

class Dashboard extends BaseComponent
{
    public $cartera;
    public $data;
    public $carteraLista;
    public function mount(){
        $this->cartera = InverCartera::where('nooperar', 0)
        ->orderBy('online', 'DESC')
        ->orderBy('operando', 'DESC')
        ->orderBy('modobot', 'DESC')
        ->orderBy('profit_30d', 'DESC')
        ->orderBy('profit_30d_simu', 'DESC')
        ->get()->toArray();  
        
        foreach ($this->cartera as $moneda){
            $clase_real='';
            if ($moneda['operando']==1 and $moneda['simulacion']==0){
                $clase_real='real';	
            }
            $modobot='';
            if ($moneda['modobot']==1){
                $modobot=' <span class="modobot">BOT</span>';
            }
            $this->carteraLista[]=[
                'id'=>$moneda['id_mon'],
                'simbolos'=> '<a href="/exchange/' . $moneda['id_mon'] . '">' . $moneda['simbolo'] .'-'. $moneda['simbolo2'] . '</a>',
                'online'=>$moneda['online'],
                'operando'=>$moneda['operando'],
                'ordenes'=>'-',
            ];
        }

      //  dd($this->carteraLista);
        $this->data=$this->carteraLista;

      //  $this->data = [
        //    ['id' => 1, 'nombre' => 'Juan', 'email' => 'juan@example.com'],
         //   ['id' => 2, 'nombre' => 'María', 'email' => 'maria@example.com'],
            // Otros datos
        //];
    }

    public function render()
    {
        return view('livewire.dashboard');
    }
}
