<?php

namespace App\Http\Livewire;
use App\Services\MecubroService;
use Livewire\Component;
use Carbon\Carbon;

class CardCobros extends Component
{
    public $operacionesHoy;
    public $operacionesAyer;
    public $totalHoy;
    public $totalAyer;

    function mount(MecubroService $mecubroService)
    {
        $date = Carbon::now();
        $hoy = $date->format('Y-m-d');
        $ayer = $date->subDay(1)->format('Y-m-d');

        //datos de hoy
        $result = $mecubroService->operaciones([
            'filter[deposited][eq]' => $hoy,
            'sort_by' => '-id',
            'limit' => 3000,
        ]);
        if ($result['result']==1) {
            $this->operacionesHoy = $result['data'];
            foreach ($this->operacionesHoy as $hoy) {
                $this->totalHoy = $this->totalHoy + $hoy['amount'];
            }

        }

        // Datos de Ayer
        $result = $mecubroService->operaciones([
            'filter[deposited][eq]' => $ayer, //   date("Y"). date("m") . date("d")-1,
            'sort_by' => '-id',
            'limit' => 3000,
        ]);
        if ($result['result']==1) {
            $this->operacionesAyer = $result['data'];
            foreach ($this->operacionesAyer as $ayer) {
                $this->totalAyer = $this->totalAyer + $ayer['amount'];
            }
        }

    }
    public function render()
    {
        return view('livewire.card-cobros');
    }
}
