<?php

namespace App\Http\Livewire;

use Livewire\Component;
use App\Services\MecubroService;

class BtnSearchUser extends Component
{
    public $usuarios;
    public $search;


    public function render(MecubroService $mecubroService)
    {
        $this->reset('usuarios');
        if ($this->search){
            $result=$mecubroService->usuarios(['filter[name|userEntity.entity.document][like]' => $this->search, 'limit' => 5]);
            $this->usuarios=$result['data'];
        }

        return view('livewire.btn-search-user');
    }
}
